/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ContentValidation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BodyValidationRequestPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="required")
    private final Boolean required;
    @JsonProperty(value="content")
    private final Map<String, ContentValidation> content;
    @JsonProperty(value="validationMode")
    private final ValidationMode validationMode;

    @Deprecated
    @ConstructorProperties(value={"required", "content", "validationMode"})
    public BodyValidationRequestPolicy(Boolean required, Map<String, ContentValidation> content, ValidationMode validationMode) {
        this.required = required;
        this.content = content;
        this.validationMode = validationMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Map<String, ContentValidation> getContent() {
        return this.content;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BodyValidationRequestPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("required=").append(String.valueOf(this.required));
        sb.append(", content=").append(String.valueOf(this.content));
        sb.append(", validationMode=").append(String.valueOf((Object)this.validationMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BodyValidationRequestPolicy)) {
            return false;
        }
        BodyValidationRequestPolicy other = (BodyValidationRequestPolicy)((Object)o);
        return Objects.equals(this.required, other.required) && Objects.equals(this.content, other.content) && Objects.equals((Object)this.validationMode, (Object)other.validationMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.required == null ? 43 : this.required.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.validationMode == null ? 43 : this.validationMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ValidationMode implements BmcEnum
    {
        Enforcing("ENFORCING"),
        Permissive("PERMISSIVE"),
        Disabled("DISABLED");

        private final String value;
        private static Map<String, ValidationMode> map;

        private ValidationMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ValidationMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ValidationMode: " + key);
        }

        static {
            map = new HashMap<String, ValidationMode>();
            for (ValidationMode v : ValidationMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="required")
        private Boolean required;
        @JsonProperty(value="content")
        private Map<String, ContentValidation> content;
        @JsonProperty(value="validationMode")
        private ValidationMode validationMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder required(Boolean required) {
            this.required = required;
            this.__explicitlySet__.add("required");
            return this;
        }

        public Builder content(Map<String, ContentValidation> content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            this.__explicitlySet__.add("validationMode");
            return this;
        }

        public BodyValidationRequestPolicy build() {
            BodyValidationRequestPolicy model = new BodyValidationRequestPolicy(this.required, this.content, this.validationMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BodyValidationRequestPolicy model) {
            if (model.wasPropertyExplicitlySet("required")) {
                this.required(model.getRequired());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("validationMode")) {
                this.validationMode(model.getValidationMode());
            }
            return this;
        }
    }
}

