/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.CaBundle;
import com.oracle.bmc.apigateway.model.Gateway;
import com.oracle.bmc.apigateway.model.ResponseCacheDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateGatewayDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="endpointType")
    private final Gateway.EndpointType endpointType;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="responseCacheDetails")
    private final ResponseCacheDetails responseCacheDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="caBundles")
    private final List<CaBundle> caBundles;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "endpointType", "subnetId", "networkSecurityGroupIds", "certificateId", "responseCacheDetails", "freeformTags", "definedTags", "caBundles"})
    public CreateGatewayDetails(String displayName, String compartmentId, Gateway.EndpointType endpointType, String subnetId, List<String> networkSecurityGroupIds, String certificateId, ResponseCacheDetails responseCacheDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<CaBundle> caBundles) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.endpointType = endpointType;
        this.subnetId = subnetId;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.certificateId = certificateId;
        this.responseCacheDetails = responseCacheDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.caBundles = caBundles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Gateway.EndpointType getEndpointType() {
        return this.endpointType;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public ResponseCacheDetails getResponseCacheDetails() {
        return this.responseCacheDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<CaBundle> getCaBundles() {
        return this.caBundles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateGatewayDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", endpointType=").append(String.valueOf((Object)this.endpointType));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", responseCacheDetails=").append(String.valueOf((Object)this.responseCacheDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", caBundles=").append(String.valueOf(this.caBundles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateGatewayDetails)) {
            return false;
        }
        CreateGatewayDetails other = (CreateGatewayDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.endpointType, (Object)other.endpointType) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals((Object)this.responseCacheDetails, (Object)other.responseCacheDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.caBundles, other.caBundles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.endpointType == null ? 43 : this.endpointType.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.responseCacheDetails == null ? 43 : this.responseCacheDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.caBundles == null ? 43 : this.caBundles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="endpointType")
        private Gateway.EndpointType endpointType;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonProperty(value="responseCacheDetails")
        private ResponseCacheDetails responseCacheDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="caBundles")
        private List<CaBundle> caBundles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder endpointType(Gateway.EndpointType endpointType) {
            this.endpointType = endpointType;
            this.__explicitlySet__.add("endpointType");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public Builder responseCacheDetails(ResponseCacheDetails responseCacheDetails) {
            this.responseCacheDetails = responseCacheDetails;
            this.__explicitlySet__.add("responseCacheDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder caBundles(List<CaBundle> caBundles) {
            this.caBundles = caBundles;
            this.__explicitlySet__.add("caBundles");
            return this;
        }

        public CreateGatewayDetails build() {
            CreateGatewayDetails model = new CreateGatewayDetails(this.displayName, this.compartmentId, this.endpointType, this.subnetId, this.networkSecurityGroupIds, this.certificateId, this.responseCacheDetails, this.freeformTags, this.definedTags, this.caBundles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateGatewayDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("endpointType")) {
                this.endpointType(model.getEndpointType());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            if (model.wasPropertyExplicitlySet("responseCacheDetails")) {
                this.responseCacheDetails(model.getResponseCacheDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("caBundles")) {
                this.caBundles(model.getCaBundles());
            }
            return this;
        }
    }
}

