/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ClientAppDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CustomClientAppDetails
extends ClientAppDetails {
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="clientSecretId")
    private final String clientSecretId;
    @JsonProperty(value="clientSecretVersionNumber")
    private final Long clientSecretVersionNumber;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CustomClientAppDetails(String clientId, String clientSecretId, Long clientSecretVersionNumber) {
        this.clientId = clientId;
        this.clientSecretId = clientSecretId;
        this.clientSecretVersionNumber = clientSecretVersionNumber;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecretId() {
        return this.clientSecretId;
    }

    public Long getClientSecretVersionNumber() {
        return this.clientSecretVersionNumber;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomClientAppDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", clientId=").append(String.valueOf(this.clientId));
        sb.append(", clientSecretId=").append(String.valueOf(this.clientSecretId));
        sb.append(", clientSecretVersionNumber=").append(String.valueOf(this.clientSecretVersionNumber));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomClientAppDetails)) {
            return false;
        }
        CustomClientAppDetails other = (CustomClientAppDetails)((Object)o);
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecretId, other.clientSecretId) && Objects.equals(this.clientSecretVersionNumber, other.clientSecretVersionNumber) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.clientSecretId == null ? 43 : this.clientSecretId.hashCode());
        result = result * 59 + (this.clientSecretVersionNumber == null ? 43 : this.clientSecretVersionNumber.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clientId")
        private String clientId;
        @JsonProperty(value="clientSecretId")
        private String clientSecretId;
        @JsonProperty(value="clientSecretVersionNumber")
        private Long clientSecretVersionNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder clientSecretId(String clientSecretId) {
            this.clientSecretId = clientSecretId;
            this.__explicitlySet__.add("clientSecretId");
            return this;
        }

        public Builder clientSecretVersionNumber(Long clientSecretVersionNumber) {
            this.clientSecretVersionNumber = clientSecretVersionNumber;
            this.__explicitlySet__.add("clientSecretVersionNumber");
            return this;
        }

        public CustomClientAppDetails build() {
            CustomClientAppDetails model = new CustomClientAppDetails(this.clientId, this.clientSecretId, this.clientSecretVersionNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomClientAppDetails model) {
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("clientSecretId")) {
                this.clientSecretId(model.getClientSecretId());
            }
            if (model.wasPropertyExplicitlySet("clientSecretVersionNumber")) {
                this.clientSecretVersionNumber(model.getClientSecretVersionNumber());
            }
            return this;
        }
    }
}

