/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.HeaderTransformationPolicy;
import com.oracle.bmc.apigateway.model.ValidationFailurePolicy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ModifyResponseValidationFailurePolicy
extends ValidationFailurePolicy {
    @JsonProperty(value="responseCode")
    private final String responseCode;
    @JsonProperty(value="responseMessage")
    private final String responseMessage;
    @JsonProperty(value="responseHeaderTransformations")
    private final HeaderTransformationPolicy responseHeaderTransformations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ModifyResponseValidationFailurePolicy(String responseCode, String responseMessage, HeaderTransformationPolicy responseHeaderTransformations) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseHeaderTransformations = responseHeaderTransformations;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public HeaderTransformationPolicy getResponseHeaderTransformations() {
        return this.responseHeaderTransformations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModifyResponseValidationFailurePolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", responseCode=").append(String.valueOf(this.responseCode));
        sb.append(", responseMessage=").append(String.valueOf(this.responseMessage));
        sb.append(", responseHeaderTransformations=").append(String.valueOf((Object)this.responseHeaderTransformations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifyResponseValidationFailurePolicy)) {
            return false;
        }
        ModifyResponseValidationFailurePolicy other = (ModifyResponseValidationFailurePolicy)((Object)o);
        return Objects.equals(this.responseCode, other.responseCode) && Objects.equals(this.responseMessage, other.responseMessage) && Objects.equals((Object)this.responseHeaderTransformations, (Object)other.responseHeaderTransformations) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.responseCode == null ? 43 : this.responseCode.hashCode());
        result = result * 59 + (this.responseMessage == null ? 43 : this.responseMessage.hashCode());
        result = result * 59 + (this.responseHeaderTransformations == null ? 43 : this.responseHeaderTransformations.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="responseCode")
        private String responseCode;
        @JsonProperty(value="responseMessage")
        private String responseMessage;
        @JsonProperty(value="responseHeaderTransformations")
        private HeaderTransformationPolicy responseHeaderTransformations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            this.__explicitlySet__.add("responseCode");
            return this;
        }

        public Builder responseMessage(String responseMessage) {
            this.responseMessage = responseMessage;
            this.__explicitlySet__.add("responseMessage");
            return this;
        }

        public Builder responseHeaderTransformations(HeaderTransformationPolicy responseHeaderTransformations) {
            this.responseHeaderTransformations = responseHeaderTransformations;
            this.__explicitlySet__.add("responseHeaderTransformations");
            return this;
        }

        public ModifyResponseValidationFailurePolicy build() {
            ModifyResponseValidationFailurePolicy model = new ModifyResponseValidationFailurePolicy(this.responseCode, this.responseMessage, this.responseHeaderTransformations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModifyResponseValidationFailurePolicy model) {
            if (model.wasPropertyExplicitlySet("responseCode")) {
                this.responseCode(model.getResponseCode());
            }
            if (model.wasPropertyExplicitlySet("responseMessage")) {
                this.responseMessage(model.getResponseMessage());
            }
            if (model.wasPropertyExplicitlySet("responseHeaderTransformations")) {
                this.responseHeaderTransformations(model.getResponseHeaderTransformations());
            }
            return this;
        }
    }
}

