/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ClientAppDetails;
import com.oracle.bmc.apigateway.model.SourceUriDetails;
import com.oracle.bmc.apigateway.model.ValidationFailurePolicy;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class OAuth2ResponseValidationFailurePolicy
extends ValidationFailurePolicy {
    @JsonProperty(value="clientDetails")
    private final ClientAppDetails clientDetails;
    @JsonProperty(value="sourceUriDetails")
    private final SourceUriDetails sourceUriDetails;
    @JsonProperty(value="scopes")
    private final List<String> scopes;
    @JsonProperty(value="maxExpiryDurationInHours")
    private final Integer maxExpiryDurationInHours;
    @JsonProperty(value="useCookiesForSession")
    private final Boolean useCookiesForSession;
    @JsonProperty(value="useCookiesForIntermediateSteps")
    private final Boolean useCookiesForIntermediateSteps;
    @JsonProperty(value="usePkce")
    private final Boolean usePkce;
    @JsonProperty(value="responseType")
    private final ResponseType responseType;
    @JsonProperty(value="fallbackRedirectPath")
    private final String fallbackRedirectPath;
    @JsonProperty(value="logoutPath")
    private final String logoutPath;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OAuth2ResponseValidationFailurePolicy(ClientAppDetails clientDetails, SourceUriDetails sourceUriDetails, List<String> scopes, Integer maxExpiryDurationInHours, Boolean useCookiesForSession, Boolean useCookiesForIntermediateSteps, Boolean usePkce, ResponseType responseType, String fallbackRedirectPath, String logoutPath) {
        this.clientDetails = clientDetails;
        this.sourceUriDetails = sourceUriDetails;
        this.scopes = scopes;
        this.maxExpiryDurationInHours = maxExpiryDurationInHours;
        this.useCookiesForSession = useCookiesForSession;
        this.useCookiesForIntermediateSteps = useCookiesForIntermediateSteps;
        this.usePkce = usePkce;
        this.responseType = responseType;
        this.fallbackRedirectPath = fallbackRedirectPath;
        this.logoutPath = logoutPath;
    }

    public ClientAppDetails getClientDetails() {
        return this.clientDetails;
    }

    public SourceUriDetails getSourceUriDetails() {
        return this.sourceUriDetails;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Integer getMaxExpiryDurationInHours() {
        return this.maxExpiryDurationInHours;
    }

    public Boolean getUseCookiesForSession() {
        return this.useCookiesForSession;
    }

    public Boolean getUseCookiesForIntermediateSteps() {
        return this.useCookiesForIntermediateSteps;
    }

    public Boolean getUsePkce() {
        return this.usePkce;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public String getFallbackRedirectPath() {
        return this.fallbackRedirectPath;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth2ResponseValidationFailurePolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", clientDetails=").append(String.valueOf((Object)this.clientDetails));
        sb.append(", sourceUriDetails=").append(String.valueOf((Object)this.sourceUriDetails));
        sb.append(", scopes=").append(String.valueOf(this.scopes));
        sb.append(", maxExpiryDurationInHours=").append(String.valueOf(this.maxExpiryDurationInHours));
        sb.append(", useCookiesForSession=").append(String.valueOf(this.useCookiesForSession));
        sb.append(", useCookiesForIntermediateSteps=").append(String.valueOf(this.useCookiesForIntermediateSteps));
        sb.append(", usePkce=").append(String.valueOf(this.usePkce));
        sb.append(", responseType=").append(String.valueOf((Object)this.responseType));
        sb.append(", fallbackRedirectPath=").append(String.valueOf(this.fallbackRedirectPath));
        sb.append(", logoutPath=").append(String.valueOf(this.logoutPath));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2ResponseValidationFailurePolicy)) {
            return false;
        }
        OAuth2ResponseValidationFailurePolicy other = (OAuth2ResponseValidationFailurePolicy)((Object)o);
        return Objects.equals((Object)this.clientDetails, (Object)other.clientDetails) && Objects.equals((Object)this.sourceUriDetails, (Object)other.sourceUriDetails) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.maxExpiryDurationInHours, other.maxExpiryDurationInHours) && Objects.equals(this.useCookiesForSession, other.useCookiesForSession) && Objects.equals(this.useCookiesForIntermediateSteps, other.useCookiesForIntermediateSteps) && Objects.equals(this.usePkce, other.usePkce) && Objects.equals((Object)this.responseType, (Object)other.responseType) && Objects.equals(this.fallbackRedirectPath, other.fallbackRedirectPath) && Objects.equals(this.logoutPath, other.logoutPath) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clientDetails == null ? 43 : this.clientDetails.hashCode());
        result = result * 59 + (this.sourceUriDetails == null ? 43 : this.sourceUriDetails.hashCode());
        result = result * 59 + (this.scopes == null ? 43 : this.scopes.hashCode());
        result = result * 59 + (this.maxExpiryDurationInHours == null ? 43 : this.maxExpiryDurationInHours.hashCode());
        result = result * 59 + (this.useCookiesForSession == null ? 43 : this.useCookiesForSession.hashCode());
        result = result * 59 + (this.useCookiesForIntermediateSteps == null ? 43 : this.useCookiesForIntermediateSteps.hashCode());
        result = result * 59 + (this.usePkce == null ? 43 : this.usePkce.hashCode());
        result = result * 59 + (this.responseType == null ? 43 : this.responseType.hashCode());
        result = result * 59 + (this.fallbackRedirectPath == null ? 43 : this.fallbackRedirectPath.hashCode());
        result = result * 59 + (this.logoutPath == null ? 43 : this.logoutPath.hashCode());
        return result;
    }

    public static enum ResponseType implements BmcEnum
    {
        Code("CODE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResponseType> map;

        private ResponseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResponseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResponseType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResponseType.class);
            map = new HashMap<String, ResponseType>();
            for (ResponseType v : ResponseType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clientDetails")
        private ClientAppDetails clientDetails;
        @JsonProperty(value="sourceUriDetails")
        private SourceUriDetails sourceUriDetails;
        @JsonProperty(value="scopes")
        private List<String> scopes;
        @JsonProperty(value="maxExpiryDurationInHours")
        private Integer maxExpiryDurationInHours;
        @JsonProperty(value="useCookiesForSession")
        private Boolean useCookiesForSession;
        @JsonProperty(value="useCookiesForIntermediateSteps")
        private Boolean useCookiesForIntermediateSteps;
        @JsonProperty(value="usePkce")
        private Boolean usePkce;
        @JsonProperty(value="responseType")
        private ResponseType responseType;
        @JsonProperty(value="fallbackRedirectPath")
        private String fallbackRedirectPath;
        @JsonProperty(value="logoutPath")
        private String logoutPath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clientDetails(ClientAppDetails clientDetails) {
            this.clientDetails = clientDetails;
            this.__explicitlySet__.add("clientDetails");
            return this;
        }

        public Builder sourceUriDetails(SourceUriDetails sourceUriDetails) {
            this.sourceUriDetails = sourceUriDetails;
            this.__explicitlySet__.add("sourceUriDetails");
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = scopes;
            this.__explicitlySet__.add("scopes");
            return this;
        }

        public Builder maxExpiryDurationInHours(Integer maxExpiryDurationInHours) {
            this.maxExpiryDurationInHours = maxExpiryDurationInHours;
            this.__explicitlySet__.add("maxExpiryDurationInHours");
            return this;
        }

        public Builder useCookiesForSession(Boolean useCookiesForSession) {
            this.useCookiesForSession = useCookiesForSession;
            this.__explicitlySet__.add("useCookiesForSession");
            return this;
        }

        public Builder useCookiesForIntermediateSteps(Boolean useCookiesForIntermediateSteps) {
            this.useCookiesForIntermediateSteps = useCookiesForIntermediateSteps;
            this.__explicitlySet__.add("useCookiesForIntermediateSteps");
            return this;
        }

        public Builder usePkce(Boolean usePkce) {
            this.usePkce = usePkce;
            this.__explicitlySet__.add("usePkce");
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.responseType = responseType;
            this.__explicitlySet__.add("responseType");
            return this;
        }

        public Builder fallbackRedirectPath(String fallbackRedirectPath) {
            this.fallbackRedirectPath = fallbackRedirectPath;
            this.__explicitlySet__.add("fallbackRedirectPath");
            return this;
        }

        public Builder logoutPath(String logoutPath) {
            this.logoutPath = logoutPath;
            this.__explicitlySet__.add("logoutPath");
            return this;
        }

        public OAuth2ResponseValidationFailurePolicy build() {
            OAuth2ResponseValidationFailurePolicy model = new OAuth2ResponseValidationFailurePolicy(this.clientDetails, this.sourceUriDetails, this.scopes, this.maxExpiryDurationInHours, this.useCookiesForSession, this.useCookiesForIntermediateSteps, this.usePkce, this.responseType, this.fallbackRedirectPath, this.logoutPath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OAuth2ResponseValidationFailurePolicy model) {
            if (model.wasPropertyExplicitlySet("clientDetails")) {
                this.clientDetails(model.getClientDetails());
            }
            if (model.wasPropertyExplicitlySet("sourceUriDetails")) {
                this.sourceUriDetails(model.getSourceUriDetails());
            }
            if (model.wasPropertyExplicitlySet("scopes")) {
                this.scopes(model.getScopes());
            }
            if (model.wasPropertyExplicitlySet("maxExpiryDurationInHours")) {
                this.maxExpiryDurationInHours(model.getMaxExpiryDurationInHours());
            }
            if (model.wasPropertyExplicitlySet("useCookiesForSession")) {
                this.useCookiesForSession(model.getUseCookiesForSession());
            }
            if (model.wasPropertyExplicitlySet("useCookiesForIntermediateSteps")) {
                this.useCookiesForIntermediateSteps(model.getUseCookiesForIntermediateSteps());
            }
            if (model.wasPropertyExplicitlySet("usePkce")) {
                this.usePkce(model.getUsePkce());
            }
            if (model.wasPropertyExplicitlySet("responseType")) {
                this.responseType(model.getResponseType());
            }
            if (model.wasPropertyExplicitlySet("fallbackRedirectPath")) {
                this.fallbackRedirectPath(model.getFallbackRedirectPath());
            }
            if (model.wasPropertyExplicitlySet("logoutPath")) {
                this.logoutPath(model.getLogoutPath());
            }
            return this;
        }
    }
}

