/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.QueryParameterValidationItem;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryParameterValidationRequestPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="parameters")
    private final List<QueryParameterValidationItem> parameters;
    @JsonProperty(value="validationMode")
    private final ValidationMode validationMode;

    @Deprecated
    @ConstructorProperties(value={"parameters", "validationMode"})
    public QueryParameterValidationRequestPolicy(List<QueryParameterValidationItem> parameters, ValidationMode validationMode) {
        this.parameters = parameters;
        this.validationMode = validationMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<QueryParameterValidationItem> getParameters() {
        return this.parameters;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryParameterValidationRequestPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("parameters=").append(String.valueOf(this.parameters));
        sb.append(", validationMode=").append(String.valueOf((Object)this.validationMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryParameterValidationRequestPolicy)) {
            return false;
        }
        QueryParameterValidationRequestPolicy other = (QueryParameterValidationRequestPolicy)((Object)o);
        return Objects.equals(this.parameters, other.parameters) && Objects.equals((Object)this.validationMode, (Object)other.validationMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.validationMode == null ? 43 : this.validationMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ValidationMode implements BmcEnum
    {
        Enforcing("ENFORCING"),
        Permissive("PERMISSIVE"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ValidationMode> map;

        private ValidationMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ValidationMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ValidationMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ValidationMode.class);
            map = new HashMap<String, ValidationMode>();
            for (ValidationMode v : ValidationMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parameters")
        private List<QueryParameterValidationItem> parameters;
        @JsonProperty(value="validationMode")
        private ValidationMode validationMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parameters(List<QueryParameterValidationItem> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            this.__explicitlySet__.add("validationMode");
            return this;
        }

        public QueryParameterValidationRequestPolicy build() {
            QueryParameterValidationRequestPolicy model = new QueryParameterValidationRequestPolicy(this.parameters, this.validationMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryParameterValidationRequestPolicy model) {
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("validationMode")) {
                this.validationMode(model.getValidationMode());
            }
            return this;
        }
    }
}

