/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.SdkLanguageOptionalParametersAllowedValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SdkLanguageOptionalParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="paramName")
    private final String paramName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;
    @JsonProperty(value="maxSize")
    private final BigDecimal maxSize;
    @JsonProperty(value="inputType")
    private final InputType inputType;
    @JsonProperty(value="allowedValues")
    private final List<SdkLanguageOptionalParametersAllowedValue> allowedValues;

    @Deprecated
    @ConstructorProperties(value={"paramName", "displayName", "description", "isRequired", "maxSize", "inputType", "allowedValues"})
    public SdkLanguageOptionalParameters(String paramName, String displayName, String description, Boolean isRequired, BigDecimal maxSize, InputType inputType, List<SdkLanguageOptionalParametersAllowedValue> allowedValues) {
        this.paramName = paramName;
        this.displayName = displayName;
        this.description = description;
        this.isRequired = isRequired;
        this.maxSize = maxSize;
        this.inputType = inputType;
        this.allowedValues = allowedValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public BigDecimal getMaxSize() {
        return this.maxSize;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public List<SdkLanguageOptionalParametersAllowedValue> getAllowedValues() {
        return this.allowedValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SdkLanguageOptionalParameters(");
        sb.append("super=").append(super.toString());
        sb.append("paramName=").append(String.valueOf(this.paramName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(", maxSize=").append(String.valueOf(this.maxSize));
        sb.append(", inputType=").append(String.valueOf((Object)this.inputType));
        sb.append(", allowedValues=").append(String.valueOf(this.allowedValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkLanguageOptionalParameters)) {
            return false;
        }
        SdkLanguageOptionalParameters other = (SdkLanguageOptionalParameters)((Object)o);
        return Objects.equals(this.paramName, other.paramName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.isRequired, other.isRequired) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals((Object)this.inputType, (Object)other.inputType) && Objects.equals(this.allowedValues, other.allowedValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.paramName == null ? 43 : this.paramName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + (this.maxSize == null ? 43 : this.maxSize.hashCode());
        result = result * 59 + (this.inputType == null ? 43 : this.inputType.hashCode());
        result = result * 59 + (this.allowedValues == null ? 43 : this.allowedValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InputType implements BmcEnum
    {
        Enum("ENUM"),
        Email("EMAIL"),
        Uri("URI"),
        String("STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InputType> map;

        private InputType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InputType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InputType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InputType.class);
            map = new HashMap<String, InputType>();
            for (InputType v : InputType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="paramName")
        private String paramName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonProperty(value="maxSize")
        private BigDecimal maxSize;
        @JsonProperty(value="inputType")
        private InputType inputType;
        @JsonProperty(value="allowedValues")
        private List<SdkLanguageOptionalParametersAllowedValue> allowedValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder paramName(String paramName) {
            this.paramName = paramName;
            this.__explicitlySet__.add("paramName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public Builder maxSize(BigDecimal maxSize) {
            this.maxSize = maxSize;
            this.__explicitlySet__.add("maxSize");
            return this;
        }

        public Builder inputType(InputType inputType) {
            this.inputType = inputType;
            this.__explicitlySet__.add("inputType");
            return this;
        }

        public Builder allowedValues(List<SdkLanguageOptionalParametersAllowedValue> allowedValues) {
            this.allowedValues = allowedValues;
            this.__explicitlySet__.add("allowedValues");
            return this;
        }

        public SdkLanguageOptionalParameters build() {
            SdkLanguageOptionalParameters model = new SdkLanguageOptionalParameters(this.paramName, this.displayName, this.description, this.isRequired, this.maxSize, this.inputType, this.allowedValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SdkLanguageOptionalParameters model) {
            if (model.wasPropertyExplicitlySet("paramName")) {
                this.paramName(model.getParamName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            if (model.wasPropertyExplicitlySet("maxSize")) {
                this.maxSize(model.getMaxSize());
            }
            if (model.wasPropertyExplicitlySet("inputType")) {
                this.inputType(model.getInputType());
            }
            if (model.wasPropertyExplicitlySet("allowedValues")) {
                this.allowedValues(model.getAllowedValues());
            }
            return this;
        }
    }
}

