/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AuthenticationPolicy;
import com.oracle.bmc.apigateway.model.TokenAuthenticationValidationPolicy;
import com.oracle.bmc.apigateway.model.ValidationFailurePolicy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class TokenAuthenticationPolicy
extends AuthenticationPolicy {
    @JsonProperty(value="tokenHeader")
    private final String tokenHeader;
    @JsonProperty(value="tokenQueryParam")
    private final String tokenQueryParam;
    @JsonProperty(value="tokenAuthScheme")
    private final String tokenAuthScheme;
    @JsonProperty(value="maxClockSkewInSeconds")
    private final Float maxClockSkewInSeconds;
    @JsonProperty(value="validationPolicy")
    private final TokenAuthenticationValidationPolicy validationPolicy;
    @JsonProperty(value="validationFailurePolicy")
    private final ValidationFailurePolicy validationFailurePolicy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TokenAuthenticationPolicy(Boolean isAnonymousAccessAllowed, String tokenHeader, String tokenQueryParam, String tokenAuthScheme, Float maxClockSkewInSeconds, TokenAuthenticationValidationPolicy validationPolicy, ValidationFailurePolicy validationFailurePolicy) {
        super(isAnonymousAccessAllowed);
        this.tokenHeader = tokenHeader;
        this.tokenQueryParam = tokenQueryParam;
        this.tokenAuthScheme = tokenAuthScheme;
        this.maxClockSkewInSeconds = maxClockSkewInSeconds;
        this.validationPolicy = validationPolicy;
        this.validationFailurePolicy = validationFailurePolicy;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public String getTokenQueryParam() {
        return this.tokenQueryParam;
    }

    public String getTokenAuthScheme() {
        return this.tokenAuthScheme;
    }

    public Float getMaxClockSkewInSeconds() {
        return this.maxClockSkewInSeconds;
    }

    public TokenAuthenticationValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    public ValidationFailurePolicy getValidationFailurePolicy() {
        return this.validationFailurePolicy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TokenAuthenticationPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", tokenHeader=").append(String.valueOf(this.tokenHeader));
        sb.append(", tokenQueryParam=").append(String.valueOf(this.tokenQueryParam));
        sb.append(", tokenAuthScheme=").append(String.valueOf(this.tokenAuthScheme));
        sb.append(", maxClockSkewInSeconds=").append(String.valueOf(this.maxClockSkewInSeconds));
        sb.append(", validationPolicy=").append(String.valueOf((Object)this.validationPolicy));
        sb.append(", validationFailurePolicy=").append(String.valueOf((Object)this.validationFailurePolicy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenAuthenticationPolicy)) {
            return false;
        }
        TokenAuthenticationPolicy other = (TokenAuthenticationPolicy)((Object)o);
        return Objects.equals(this.tokenHeader, other.tokenHeader) && Objects.equals(this.tokenQueryParam, other.tokenQueryParam) && Objects.equals(this.tokenAuthScheme, other.tokenAuthScheme) && Objects.equals(this.maxClockSkewInSeconds, other.maxClockSkewInSeconds) && Objects.equals((Object)this.validationPolicy, (Object)other.validationPolicy) && Objects.equals((Object)this.validationFailurePolicy, (Object)other.validationFailurePolicy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tokenHeader == null ? 43 : this.tokenHeader.hashCode());
        result = result * 59 + (this.tokenQueryParam == null ? 43 : this.tokenQueryParam.hashCode());
        result = result * 59 + (this.tokenAuthScheme == null ? 43 : this.tokenAuthScheme.hashCode());
        result = result * 59 + (this.maxClockSkewInSeconds == null ? 43 : this.maxClockSkewInSeconds.hashCode());
        result = result * 59 + (this.validationPolicy == null ? 43 : this.validationPolicy.hashCode());
        result = result * 59 + (this.validationFailurePolicy == null ? 43 : this.validationFailurePolicy.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isAnonymousAccessAllowed")
        private Boolean isAnonymousAccessAllowed;
        @JsonProperty(value="tokenHeader")
        private String tokenHeader;
        @JsonProperty(value="tokenQueryParam")
        private String tokenQueryParam;
        @JsonProperty(value="tokenAuthScheme")
        private String tokenAuthScheme;
        @JsonProperty(value="maxClockSkewInSeconds")
        private Float maxClockSkewInSeconds;
        @JsonProperty(value="validationPolicy")
        private TokenAuthenticationValidationPolicy validationPolicy;
        @JsonProperty(value="validationFailurePolicy")
        private ValidationFailurePolicy validationFailurePolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isAnonymousAccessAllowed(Boolean isAnonymousAccessAllowed) {
            this.isAnonymousAccessAllowed = isAnonymousAccessAllowed;
            this.__explicitlySet__.add("isAnonymousAccessAllowed");
            return this;
        }

        public Builder tokenHeader(String tokenHeader) {
            this.tokenHeader = tokenHeader;
            this.__explicitlySet__.add("tokenHeader");
            return this;
        }

        public Builder tokenQueryParam(String tokenQueryParam) {
            this.tokenQueryParam = tokenQueryParam;
            this.__explicitlySet__.add("tokenQueryParam");
            return this;
        }

        public Builder tokenAuthScheme(String tokenAuthScheme) {
            this.tokenAuthScheme = tokenAuthScheme;
            this.__explicitlySet__.add("tokenAuthScheme");
            return this;
        }

        public Builder maxClockSkewInSeconds(Float maxClockSkewInSeconds) {
            this.maxClockSkewInSeconds = maxClockSkewInSeconds;
            this.__explicitlySet__.add("maxClockSkewInSeconds");
            return this;
        }

        public Builder validationPolicy(TokenAuthenticationValidationPolicy validationPolicy) {
            this.validationPolicy = validationPolicy;
            this.__explicitlySet__.add("validationPolicy");
            return this;
        }

        public Builder validationFailurePolicy(ValidationFailurePolicy validationFailurePolicy) {
            this.validationFailurePolicy = validationFailurePolicy;
            this.__explicitlySet__.add("validationFailurePolicy");
            return this;
        }

        public TokenAuthenticationPolicy build() {
            TokenAuthenticationPolicy model = new TokenAuthenticationPolicy(this.isAnonymousAccessAllowed, this.tokenHeader, this.tokenQueryParam, this.tokenAuthScheme, this.maxClockSkewInSeconds, this.validationPolicy, this.validationFailurePolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TokenAuthenticationPolicy model) {
            if (model.wasPropertyExplicitlySet("isAnonymousAccessAllowed")) {
                this.isAnonymousAccessAllowed(model.getIsAnonymousAccessAllowed());
            }
            if (model.wasPropertyExplicitlySet("tokenHeader")) {
                this.tokenHeader(model.getTokenHeader());
            }
            if (model.wasPropertyExplicitlySet("tokenQueryParam")) {
                this.tokenQueryParam(model.getTokenQueryParam());
            }
            if (model.wasPropertyExplicitlySet("tokenAuthScheme")) {
                this.tokenAuthScheme(model.getTokenAuthScheme());
            }
            if (model.wasPropertyExplicitlySet("maxClockSkewInSeconds")) {
                this.maxClockSkewInSeconds(model.getMaxClockSkewInSeconds());
            }
            if (model.wasPropertyExplicitlySet("validationPolicy")) {
                this.validationPolicy(model.getValidationPolicy());
            }
            if (model.wasPropertyExplicitlySet("validationFailurePolicy")) {
                this.validationFailurePolicy(model.getValidationFailurePolicy());
            }
            return this;
        }
    }
}

