/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AdditionalValidationPolicy;
import com.oracle.bmc.apigateway.model.ClientAppDetails;
import com.oracle.bmc.apigateway.model.SourceUriDetails;
import com.oracle.bmc.apigateway.model.TokenAuthenticationValidationPolicy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class TokenAuthenticationRemoteDiscoveryValidationPolicy
extends TokenAuthenticationValidationPolicy {
    @JsonProperty(value="clientDetails")
    private final ClientAppDetails clientDetails;
    @JsonProperty(value="sourceUriDetails")
    private final SourceUriDetails sourceUriDetails;
    @JsonProperty(value="isSslVerifyDisabled")
    private final Boolean isSslVerifyDisabled;
    @JsonProperty(value="maxCacheDurationInHours")
    private final Integer maxCacheDurationInHours;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TokenAuthenticationRemoteDiscoveryValidationPolicy(AdditionalValidationPolicy additionalValidationPolicy, ClientAppDetails clientDetails, SourceUriDetails sourceUriDetails, Boolean isSslVerifyDisabled, Integer maxCacheDurationInHours) {
        super(additionalValidationPolicy);
        this.clientDetails = clientDetails;
        this.sourceUriDetails = sourceUriDetails;
        this.isSslVerifyDisabled = isSslVerifyDisabled;
        this.maxCacheDurationInHours = maxCacheDurationInHours;
    }

    public ClientAppDetails getClientDetails() {
        return this.clientDetails;
    }

    public SourceUriDetails getSourceUriDetails() {
        return this.sourceUriDetails;
    }

    public Boolean getIsSslVerifyDisabled() {
        return this.isSslVerifyDisabled;
    }

    public Integer getMaxCacheDurationInHours() {
        return this.maxCacheDurationInHours;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TokenAuthenticationRemoteDiscoveryValidationPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", clientDetails=").append(String.valueOf((Object)this.clientDetails));
        sb.append(", sourceUriDetails=").append(String.valueOf((Object)this.sourceUriDetails));
        sb.append(", isSslVerifyDisabled=").append(String.valueOf(this.isSslVerifyDisabled));
        sb.append(", maxCacheDurationInHours=").append(String.valueOf(this.maxCacheDurationInHours));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenAuthenticationRemoteDiscoveryValidationPolicy)) {
            return false;
        }
        TokenAuthenticationRemoteDiscoveryValidationPolicy other = (TokenAuthenticationRemoteDiscoveryValidationPolicy)((Object)o);
        return Objects.equals((Object)this.clientDetails, (Object)other.clientDetails) && Objects.equals((Object)this.sourceUriDetails, (Object)other.sourceUriDetails) && Objects.equals(this.isSslVerifyDisabled, other.isSslVerifyDisabled) && Objects.equals(this.maxCacheDurationInHours, other.maxCacheDurationInHours) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clientDetails == null ? 43 : this.clientDetails.hashCode());
        result = result * 59 + (this.sourceUriDetails == null ? 43 : this.sourceUriDetails.hashCode());
        result = result * 59 + (this.isSslVerifyDisabled == null ? 43 : this.isSslVerifyDisabled.hashCode());
        result = result * 59 + (this.maxCacheDurationInHours == null ? 43 : this.maxCacheDurationInHours.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="additionalValidationPolicy")
        private AdditionalValidationPolicy additionalValidationPolicy;
        @JsonProperty(value="clientDetails")
        private ClientAppDetails clientDetails;
        @JsonProperty(value="sourceUriDetails")
        private SourceUriDetails sourceUriDetails;
        @JsonProperty(value="isSslVerifyDisabled")
        private Boolean isSslVerifyDisabled;
        @JsonProperty(value="maxCacheDurationInHours")
        private Integer maxCacheDurationInHours;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder additionalValidationPolicy(AdditionalValidationPolicy additionalValidationPolicy) {
            this.additionalValidationPolicy = additionalValidationPolicy;
            this.__explicitlySet__.add("additionalValidationPolicy");
            return this;
        }

        public Builder clientDetails(ClientAppDetails clientDetails) {
            this.clientDetails = clientDetails;
            this.__explicitlySet__.add("clientDetails");
            return this;
        }

        public Builder sourceUriDetails(SourceUriDetails sourceUriDetails) {
            this.sourceUriDetails = sourceUriDetails;
            this.__explicitlySet__.add("sourceUriDetails");
            return this;
        }

        public Builder isSslVerifyDisabled(Boolean isSslVerifyDisabled) {
            this.isSslVerifyDisabled = isSslVerifyDisabled;
            this.__explicitlySet__.add("isSslVerifyDisabled");
            return this;
        }

        public Builder maxCacheDurationInHours(Integer maxCacheDurationInHours) {
            this.maxCacheDurationInHours = maxCacheDurationInHours;
            this.__explicitlySet__.add("maxCacheDurationInHours");
            return this;
        }

        public TokenAuthenticationRemoteDiscoveryValidationPolicy build() {
            TokenAuthenticationRemoteDiscoveryValidationPolicy model = new TokenAuthenticationRemoteDiscoveryValidationPolicy(this.additionalValidationPolicy, this.clientDetails, this.sourceUriDetails, this.isSslVerifyDisabled, this.maxCacheDurationInHours);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TokenAuthenticationRemoteDiscoveryValidationPolicy model) {
            if (model.wasPropertyExplicitlySet("additionalValidationPolicy")) {
                this.additionalValidationPolicy(model.getAdditionalValidationPolicy());
            }
            if (model.wasPropertyExplicitlySet("clientDetails")) {
                this.clientDetails(model.getClientDetails());
            }
            if (model.wasPropertyExplicitlySet("sourceUriDetails")) {
                this.sourceUriDetails(model.getSourceUriDetails());
            }
            if (model.wasPropertyExplicitlySet("isSslVerifyDisabled")) {
                this.isSslVerifyDisabled(model.getIsSslVerifyDisabled());
            }
            if (model.wasPropertyExplicitlySet("maxCacheDurationInHours")) {
                this.maxCacheDurationInHours(model.getMaxCacheDurationInHours());
            }
            return this;
        }
    }
}

