/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AuthenticationPolicy;
import com.oracle.bmc.apigateway.model.CorsPolicy;
import com.oracle.bmc.apigateway.model.DynamicAuthenticationPolicy;
import com.oracle.bmc.apigateway.model.MutualTlsDetails;
import com.oracle.bmc.apigateway.model.RateLimitingPolicy;
import com.oracle.bmc.apigateway.model.UsagePlansPolicy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiSpecificationRequestPolicies
extends ExplicitlySetBmcModel {
    @JsonProperty(value="authentication")
    private final AuthenticationPolicy authentication;
    @JsonProperty(value="rateLimiting")
    private final RateLimitingPolicy rateLimiting;
    @JsonProperty(value="cors")
    private final CorsPolicy cors;
    @JsonProperty(value="mutualTls")
    private final MutualTlsDetails mutualTls;
    @JsonProperty(value="usagePlans")
    private final UsagePlansPolicy usagePlans;
    @JsonProperty(value="dynamicAuthentication")
    private final DynamicAuthenticationPolicy dynamicAuthentication;

    @Deprecated
    @ConstructorProperties(value={"authentication", "rateLimiting", "cors", "mutualTls", "usagePlans", "dynamicAuthentication"})
    public ApiSpecificationRequestPolicies(AuthenticationPolicy authentication, RateLimitingPolicy rateLimiting, CorsPolicy cors, MutualTlsDetails mutualTls, UsagePlansPolicy usagePlans, DynamicAuthenticationPolicy dynamicAuthentication) {
        this.authentication = authentication;
        this.rateLimiting = rateLimiting;
        this.cors = cors;
        this.mutualTls = mutualTls;
        this.usagePlans = usagePlans;
        this.dynamicAuthentication = dynamicAuthentication;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AuthenticationPolicy getAuthentication() {
        return this.authentication;
    }

    public RateLimitingPolicy getRateLimiting() {
        return this.rateLimiting;
    }

    public CorsPolicy getCors() {
        return this.cors;
    }

    public MutualTlsDetails getMutualTls() {
        return this.mutualTls;
    }

    public UsagePlansPolicy getUsagePlans() {
        return this.usagePlans;
    }

    public DynamicAuthenticationPolicy getDynamicAuthentication() {
        return this.dynamicAuthentication;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiSpecificationRequestPolicies(");
        sb.append("super=").append(super.toString());
        sb.append("authentication=").append(String.valueOf((Object)this.authentication));
        sb.append(", rateLimiting=").append(String.valueOf((Object)this.rateLimiting));
        sb.append(", cors=").append(String.valueOf((Object)this.cors));
        sb.append(", mutualTls=").append(String.valueOf((Object)this.mutualTls));
        sb.append(", usagePlans=").append(String.valueOf((Object)this.usagePlans));
        sb.append(", dynamicAuthentication=").append(String.valueOf((Object)this.dynamicAuthentication));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiSpecificationRequestPolicies)) {
            return false;
        }
        ApiSpecificationRequestPolicies other = (ApiSpecificationRequestPolicies)((Object)o);
        return Objects.equals((Object)this.authentication, (Object)other.authentication) && Objects.equals((Object)this.rateLimiting, (Object)other.rateLimiting) && Objects.equals((Object)this.cors, (Object)other.cors) && Objects.equals((Object)this.mutualTls, (Object)other.mutualTls) && Objects.equals((Object)this.usagePlans, (Object)other.usagePlans) && Objects.equals((Object)this.dynamicAuthentication, (Object)other.dynamicAuthentication) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authentication == null ? 43 : this.authentication.hashCode());
        result = result * 59 + (this.rateLimiting == null ? 43 : this.rateLimiting.hashCode());
        result = result * 59 + (this.cors == null ? 43 : this.cors.hashCode());
        result = result * 59 + (this.mutualTls == null ? 43 : this.mutualTls.hashCode());
        result = result * 59 + (this.usagePlans == null ? 43 : this.usagePlans.hashCode());
        result = result * 59 + (this.dynamicAuthentication == null ? 43 : this.dynamicAuthentication.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="authentication")
        private AuthenticationPolicy authentication;
        @JsonProperty(value="rateLimiting")
        private RateLimitingPolicy rateLimiting;
        @JsonProperty(value="cors")
        private CorsPolicy cors;
        @JsonProperty(value="mutualTls")
        private MutualTlsDetails mutualTls;
        @JsonProperty(value="usagePlans")
        private UsagePlansPolicy usagePlans;
        @JsonProperty(value="dynamicAuthentication")
        private DynamicAuthenticationPolicy dynamicAuthentication;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder authentication(AuthenticationPolicy authentication) {
            this.authentication = authentication;
            this.__explicitlySet__.add("authentication");
            return this;
        }

        public Builder rateLimiting(RateLimitingPolicy rateLimiting) {
            this.rateLimiting = rateLimiting;
            this.__explicitlySet__.add("rateLimiting");
            return this;
        }

        public Builder cors(CorsPolicy cors) {
            this.cors = cors;
            this.__explicitlySet__.add("cors");
            return this;
        }

        public Builder mutualTls(MutualTlsDetails mutualTls) {
            this.mutualTls = mutualTls;
            this.__explicitlySet__.add("mutualTls");
            return this;
        }

        public Builder usagePlans(UsagePlansPolicy usagePlans) {
            this.usagePlans = usagePlans;
            this.__explicitlySet__.add("usagePlans");
            return this;
        }

        public Builder dynamicAuthentication(DynamicAuthenticationPolicy dynamicAuthentication) {
            this.dynamicAuthentication = dynamicAuthentication;
            this.__explicitlySet__.add("dynamicAuthentication");
            return this;
        }

        public ApiSpecificationRequestPolicies build() {
            ApiSpecificationRequestPolicies model = new ApiSpecificationRequestPolicies(this.authentication, this.rateLimiting, this.cors, this.mutualTls, this.usagePlans, this.dynamicAuthentication);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiSpecificationRequestPolicies model) {
            if (model.wasPropertyExplicitlySet("authentication")) {
                this.authentication(model.getAuthentication());
            }
            if (model.wasPropertyExplicitlySet("rateLimiting")) {
                this.rateLimiting(model.getRateLimiting());
            }
            if (model.wasPropertyExplicitlySet("cors")) {
                this.cors(model.getCors());
            }
            if (model.wasPropertyExplicitlySet("mutualTls")) {
                this.mutualTls(model.getMutualTls());
            }
            if (model.wasPropertyExplicitlySet("usagePlans")) {
                this.usagePlans(model.getUsagePlans());
            }
            if (model.wasPropertyExplicitlySet("dynamicAuthentication")) {
                this.dynamicAuthentication(model.getDynamicAuthentication());
            }
            return this;
        }
    }
}

