/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CorsPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="allowedOrigins")
    private final List<String> allowedOrigins;
    @JsonProperty(value="allowedMethods")
    private final List<String> allowedMethods;
    @JsonProperty(value="allowedHeaders")
    private final List<String> allowedHeaders;
    @JsonProperty(value="exposedHeaders")
    private final List<String> exposedHeaders;
    @JsonProperty(value="isAllowCredentialsEnabled")
    private final Boolean isAllowCredentialsEnabled;
    @JsonProperty(value="maxAgeInSeconds")
    private final Integer maxAgeInSeconds;

    @Deprecated
    @ConstructorProperties(value={"allowedOrigins", "allowedMethods", "allowedHeaders", "exposedHeaders", "isAllowCredentialsEnabled", "maxAgeInSeconds"})
    public CorsPolicy(List<String> allowedOrigins, List<String> allowedMethods, List<String> allowedHeaders, List<String> exposedHeaders, Boolean isAllowCredentialsEnabled, Integer maxAgeInSeconds) {
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
        this.isAllowCredentialsEnabled = isAllowCredentialsEnabled;
        this.maxAgeInSeconds = maxAgeInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public Boolean getIsAllowCredentialsEnabled() {
        return this.isAllowCredentialsEnabled;
    }

    public Integer getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CorsPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("allowedOrigins=").append(String.valueOf(this.allowedOrigins));
        sb.append(", allowedMethods=").append(String.valueOf(this.allowedMethods));
        sb.append(", allowedHeaders=").append(String.valueOf(this.allowedHeaders));
        sb.append(", exposedHeaders=").append(String.valueOf(this.exposedHeaders));
        sb.append(", isAllowCredentialsEnabled=").append(String.valueOf(this.isAllowCredentialsEnabled));
        sb.append(", maxAgeInSeconds=").append(String.valueOf(this.maxAgeInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CorsPolicy)) {
            return false;
        }
        CorsPolicy other = (CorsPolicy)((Object)o);
        return Objects.equals(this.allowedOrigins, other.allowedOrigins) && Objects.equals(this.allowedMethods, other.allowedMethods) && Objects.equals(this.allowedHeaders, other.allowedHeaders) && Objects.equals(this.exposedHeaders, other.exposedHeaders) && Objects.equals(this.isAllowCredentialsEnabled, other.isAllowCredentialsEnabled) && Objects.equals(this.maxAgeInSeconds, other.maxAgeInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allowedOrigins == null ? 43 : this.allowedOrigins.hashCode());
        result = result * 59 + (this.allowedMethods == null ? 43 : this.allowedMethods.hashCode());
        result = result * 59 + (this.allowedHeaders == null ? 43 : this.allowedHeaders.hashCode());
        result = result * 59 + (this.exposedHeaders == null ? 43 : this.exposedHeaders.hashCode());
        result = result * 59 + (this.isAllowCredentialsEnabled == null ? 43 : this.isAllowCredentialsEnabled.hashCode());
        result = result * 59 + (this.maxAgeInSeconds == null ? 43 : this.maxAgeInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allowedOrigins")
        private List<String> allowedOrigins;
        @JsonProperty(value="allowedMethods")
        private List<String> allowedMethods;
        @JsonProperty(value="allowedHeaders")
        private List<String> allowedHeaders;
        @JsonProperty(value="exposedHeaders")
        private List<String> exposedHeaders;
        @JsonProperty(value="isAllowCredentialsEnabled")
        private Boolean isAllowCredentialsEnabled;
        @JsonProperty(value="maxAgeInSeconds")
        private Integer maxAgeInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
            this.__explicitlySet__.add("allowedOrigins");
            return this;
        }

        public Builder allowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
            this.__explicitlySet__.add("allowedMethods");
            return this;
        }

        public Builder allowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            this.__explicitlySet__.add("allowedHeaders");
            return this;
        }

        public Builder exposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
            this.__explicitlySet__.add("exposedHeaders");
            return this;
        }

        public Builder isAllowCredentialsEnabled(Boolean isAllowCredentialsEnabled) {
            this.isAllowCredentialsEnabled = isAllowCredentialsEnabled;
            this.__explicitlySet__.add("isAllowCredentialsEnabled");
            return this;
        }

        public Builder maxAgeInSeconds(Integer maxAgeInSeconds) {
            this.maxAgeInSeconds = maxAgeInSeconds;
            this.__explicitlySet__.add("maxAgeInSeconds");
            return this;
        }

        public CorsPolicy build() {
            CorsPolicy model = new CorsPolicy(this.allowedOrigins, this.allowedMethods, this.allowedHeaders, this.exposedHeaders, this.isAllowCredentialsEnabled, this.maxAgeInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CorsPolicy model) {
            if (model.wasPropertyExplicitlySet("allowedOrigins")) {
                this.allowedOrigins(model.getAllowedOrigins());
            }
            if (model.wasPropertyExplicitlySet("allowedMethods")) {
                this.allowedMethods(model.getAllowedMethods());
            }
            if (model.wasPropertyExplicitlySet("allowedHeaders")) {
                this.allowedHeaders(model.getAllowedHeaders());
            }
            if (model.wasPropertyExplicitlySet("exposedHeaders")) {
                this.exposedHeaders(model.getExposedHeaders());
            }
            if (model.wasPropertyExplicitlySet("isAllowCredentialsEnabled")) {
                this.isAllowCredentialsEnabled(model.getIsAllowCredentialsEnabled());
            }
            if (model.wasPropertyExplicitlySet("maxAgeInSeconds")) {
                this.maxAgeInSeconds(model.getMaxAgeInSeconds());
            }
            return this;
        }
    }
}

