/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ApiSpecification;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDeploymentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="gatewayId")
    private final String gatewayId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="pathPrefix")
    private final String pathPrefix;
    @JsonProperty(value="specification")
    private final ApiSpecification specification;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "gatewayId", "compartmentId", "pathPrefix", "specification", "freeformTags", "definedTags"})
    public CreateDeploymentDetails(String displayName, String gatewayId, String compartmentId, String pathPrefix, ApiSpecification specification, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.gatewayId = gatewayId;
        this.compartmentId = compartmentId;
        this.pathPrefix = pathPrefix;
        this.specification = specification;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public ApiSpecification getSpecification() {
        return this.specification;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDeploymentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", gatewayId=").append(String.valueOf(this.gatewayId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", pathPrefix=").append(String.valueOf(this.pathPrefix));
        sb.append(", specification=").append(String.valueOf((Object)this.specification));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDeploymentDetails)) {
            return false;
        }
        CreateDeploymentDetails other = (CreateDeploymentDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.gatewayId, other.gatewayId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.pathPrefix, other.pathPrefix) && Objects.equals((Object)this.specification, (Object)other.specification) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.gatewayId == null ? 43 : this.gatewayId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.pathPrefix == null ? 43 : this.pathPrefix.hashCode());
        result = result * 59 + (this.specification == null ? 43 : this.specification.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="gatewayId")
        private String gatewayId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="pathPrefix")
        private String pathPrefix;
        @JsonProperty(value="specification")
        private ApiSpecification specification;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            this.__explicitlySet__.add("gatewayId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            this.__explicitlySet__.add("pathPrefix");
            return this;
        }

        public Builder specification(ApiSpecification specification) {
            this.specification = specification;
            this.__explicitlySet__.add("specification");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateDeploymentDetails build() {
            CreateDeploymentDetails model = new CreateDeploymentDetails(this.displayName, this.gatewayId, this.compartmentId, this.pathPrefix, this.specification, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDeploymentDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("gatewayId")) {
                this.gatewayId(model.getGatewayId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("pathPrefix")) {
                this.pathPrefix(model.getPathPrefix());
            }
            if (model.wasPropertyExplicitlySet("specification")) {
                this.specification(model.getSpecification());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

