/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RateLimitingPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="rateInRequestsPerSecond")
    private final Integer rateInRequestsPerSecond;
    @JsonProperty(value="rateKey")
    private final RateKey rateKey;

    @Deprecated
    @ConstructorProperties(value={"rateInRequestsPerSecond", "rateKey"})
    public RateLimitingPolicy(Integer rateInRequestsPerSecond, RateKey rateKey) {
        this.rateInRequestsPerSecond = rateInRequestsPerSecond;
        this.rateKey = rateKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getRateInRequestsPerSecond() {
        return this.rateInRequestsPerSecond;
    }

    public RateKey getRateKey() {
        return this.rateKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RateLimitingPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("rateInRequestsPerSecond=").append(String.valueOf(this.rateInRequestsPerSecond));
        sb.append(", rateKey=").append(String.valueOf((Object)this.rateKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RateLimitingPolicy)) {
            return false;
        }
        RateLimitingPolicy other = (RateLimitingPolicy)((Object)o);
        return Objects.equals(this.rateInRequestsPerSecond, other.rateInRequestsPerSecond) && Objects.equals((Object)this.rateKey, (Object)other.rateKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.rateInRequestsPerSecond == null ? 43 : this.rateInRequestsPerSecond.hashCode());
        result = result * 59 + (this.rateKey == null ? 43 : this.rateKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RateKey implements BmcEnum
    {
        ClientIp("CLIENT_IP"),
        Total("TOTAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RateKey> map;

        private RateKey(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RateKey create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RateKey', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RateKey.class);
            map = new HashMap<String, RateKey>();
            for (RateKey v : RateKey.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rateInRequestsPerSecond")
        private Integer rateInRequestsPerSecond;
        @JsonProperty(value="rateKey")
        private RateKey rateKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rateInRequestsPerSecond(Integer rateInRequestsPerSecond) {
            this.rateInRequestsPerSecond = rateInRequestsPerSecond;
            this.__explicitlySet__.add("rateInRequestsPerSecond");
            return this;
        }

        public Builder rateKey(RateKey rateKey) {
            this.rateKey = rateKey;
            this.__explicitlySet__.add("rateKey");
            return this;
        }

        public RateLimitingPolicy build() {
            RateLimitingPolicy model = new RateLimitingPolicy(this.rateInRequestsPerSecond, this.rateKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RateLimitingPolicy model) {
            if (model.wasPropertyExplicitlySet("rateInRequestsPerSecond")) {
                this.rateInRequestsPerSecond(model.getRateInRequestsPerSecond());
            }
            if (model.wasPropertyExplicitlySet("rateKey")) {
                this.rateKey(model.getRateKey());
            }
            return this;
        }
    }
}

