/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ApiSpecificationLoggingPolicies;
import com.oracle.bmc.apigateway.model.ApiSpecificationRequestPolicies;
import com.oracle.bmc.apigateway.model.ApiSpecificationRoute;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApiSpecification
extends ExplicitlySetBmcModel {
    @JsonProperty(value="requestPolicies")
    private final ApiSpecificationRequestPolicies requestPolicies;
    @JsonProperty(value="loggingPolicies")
    private final ApiSpecificationLoggingPolicies loggingPolicies;
    @JsonProperty(value="routes")
    private final List<ApiSpecificationRoute> routes;

    @Deprecated
    @ConstructorProperties(value={"requestPolicies", "loggingPolicies", "routes"})
    public ApiSpecification(ApiSpecificationRequestPolicies requestPolicies, ApiSpecificationLoggingPolicies loggingPolicies, List<ApiSpecificationRoute> routes) {
        this.requestPolicies = requestPolicies;
        this.loggingPolicies = loggingPolicies;
        this.routes = routes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ApiSpecificationRequestPolicies getRequestPolicies() {
        return this.requestPolicies;
    }

    public ApiSpecificationLoggingPolicies getLoggingPolicies() {
        return this.loggingPolicies;
    }

    public List<ApiSpecificationRoute> getRoutes() {
        return this.routes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApiSpecification(");
        sb.append("super=").append(super.toString());
        sb.append("requestPolicies=").append(String.valueOf((Object)this.requestPolicies));
        sb.append(", loggingPolicies=").append(String.valueOf((Object)this.loggingPolicies));
        sb.append(", routes=").append(String.valueOf(this.routes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiSpecification)) {
            return false;
        }
        ApiSpecification other = (ApiSpecification)((Object)o);
        return Objects.equals((Object)this.requestPolicies, (Object)other.requestPolicies) && Objects.equals((Object)this.loggingPolicies, (Object)other.loggingPolicies) && Objects.equals(this.routes, other.routes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.requestPolicies == null ? 43 : this.requestPolicies.hashCode());
        result = result * 59 + (this.loggingPolicies == null ? 43 : this.loggingPolicies.hashCode());
        result = result * 59 + (this.routes == null ? 43 : this.routes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="requestPolicies")
        private ApiSpecificationRequestPolicies requestPolicies;
        @JsonProperty(value="loggingPolicies")
        private ApiSpecificationLoggingPolicies loggingPolicies;
        @JsonProperty(value="routes")
        private List<ApiSpecificationRoute> routes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder requestPolicies(ApiSpecificationRequestPolicies requestPolicies) {
            this.requestPolicies = requestPolicies;
            this.__explicitlySet__.add("requestPolicies");
            return this;
        }

        public Builder loggingPolicies(ApiSpecificationLoggingPolicies loggingPolicies) {
            this.loggingPolicies = loggingPolicies;
            this.__explicitlySet__.add("loggingPolicies");
            return this;
        }

        public Builder routes(List<ApiSpecificationRoute> routes) {
            this.routes = routes;
            this.__explicitlySet__.add("routes");
            return this;
        }

        public ApiSpecification build() {
            ApiSpecification model = new ApiSpecification(this.requestPolicies, this.loggingPolicies, this.routes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApiSpecification model) {
            if (model.wasPropertyExplicitlySet("requestPolicies")) {
                this.requestPolicies(model.getRequestPolicies());
            }
            if (model.wasPropertyExplicitlySet("loggingPolicies")) {
                this.loggingPolicies(model.getLoggingPolicies());
            }
            if (model.wasPropertyExplicitlySet("routes")) {
                this.routes(model.getRoutes());
            }
            return this;
        }
    }
}

