/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.AuthenticationPolicy;
import com.oracle.bmc.apigateway.model.ValidationFailurePolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class CustomAuthenticationPolicy
extends AuthenticationPolicy {
    @JsonProperty(value="functionId")
    private final String functionId;
    @JsonProperty(value="tokenHeader")
    private final String tokenHeader;
    @JsonProperty(value="tokenQueryParam")
    private final String tokenQueryParam;
    @JsonProperty(value="parameters")
    private final Map<String, String> parameters;
    @JsonProperty(value="cacheKey")
    private final List<String> cacheKey;
    @JsonProperty(value="validationFailurePolicy")
    private final ValidationFailurePolicy validationFailurePolicy;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CustomAuthenticationPolicy(Boolean isAnonymousAccessAllowed, String functionId, String tokenHeader, String tokenQueryParam, Map<String, String> parameters, List<String> cacheKey, ValidationFailurePolicy validationFailurePolicy) {
        super(isAnonymousAccessAllowed);
        this.functionId = functionId;
        this.tokenHeader = tokenHeader;
        this.tokenQueryParam = tokenQueryParam;
        this.parameters = parameters;
        this.cacheKey = cacheKey;
        this.validationFailurePolicy = validationFailurePolicy;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public String getTokenQueryParam() {
        return this.tokenQueryParam;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<String> getCacheKey() {
        return this.cacheKey;
    }

    public ValidationFailurePolicy getValidationFailurePolicy() {
        return this.validationFailurePolicy;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomAuthenticationPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", functionId=").append(String.valueOf(this.functionId));
        sb.append(", tokenHeader=").append(String.valueOf(this.tokenHeader));
        sb.append(", tokenQueryParam=").append(String.valueOf(this.tokenQueryParam));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", cacheKey=").append(String.valueOf(this.cacheKey));
        sb.append(", validationFailurePolicy=").append(String.valueOf((Object)this.validationFailurePolicy));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomAuthenticationPolicy)) {
            return false;
        }
        CustomAuthenticationPolicy other = (CustomAuthenticationPolicy)((Object)o);
        return Objects.equals(this.functionId, other.functionId) && Objects.equals(this.tokenHeader, other.tokenHeader) && Objects.equals(this.tokenQueryParam, other.tokenQueryParam) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.cacheKey, other.cacheKey) && Objects.equals((Object)this.validationFailurePolicy, (Object)other.validationFailurePolicy) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.tokenHeader == null ? 43 : this.tokenHeader.hashCode());
        result = result * 59 + (this.tokenQueryParam == null ? 43 : this.tokenQueryParam.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.cacheKey == null ? 43 : this.cacheKey.hashCode());
        result = result * 59 + (this.validationFailurePolicy == null ? 43 : this.validationFailurePolicy.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isAnonymousAccessAllowed")
        private Boolean isAnonymousAccessAllowed;
        @JsonProperty(value="functionId")
        private String functionId;
        @JsonProperty(value="tokenHeader")
        private String tokenHeader;
        @JsonProperty(value="tokenQueryParam")
        private String tokenQueryParam;
        @JsonProperty(value="parameters")
        private Map<String, String> parameters;
        @JsonProperty(value="cacheKey")
        private List<String> cacheKey;
        @JsonProperty(value="validationFailurePolicy")
        private ValidationFailurePolicy validationFailurePolicy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isAnonymousAccessAllowed(Boolean isAnonymousAccessAllowed) {
            this.isAnonymousAccessAllowed = isAnonymousAccessAllowed;
            this.__explicitlySet__.add("isAnonymousAccessAllowed");
            return this;
        }

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            this.__explicitlySet__.add("functionId");
            return this;
        }

        public Builder tokenHeader(String tokenHeader) {
            this.tokenHeader = tokenHeader;
            this.__explicitlySet__.add("tokenHeader");
            return this;
        }

        public Builder tokenQueryParam(String tokenQueryParam) {
            this.tokenQueryParam = tokenQueryParam;
            this.__explicitlySet__.add("tokenQueryParam");
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder cacheKey(List<String> cacheKey) {
            this.cacheKey = cacheKey;
            this.__explicitlySet__.add("cacheKey");
            return this;
        }

        public Builder validationFailurePolicy(ValidationFailurePolicy validationFailurePolicy) {
            this.validationFailurePolicy = validationFailurePolicy;
            this.__explicitlySet__.add("validationFailurePolicy");
            return this;
        }

        public CustomAuthenticationPolicy build() {
            CustomAuthenticationPolicy model = new CustomAuthenticationPolicy(this.isAnonymousAccessAllowed, this.functionId, this.tokenHeader, this.tokenQueryParam, this.parameters, this.cacheKey, this.validationFailurePolicy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomAuthenticationPolicy model) {
            if (model.wasPropertyExplicitlySet("isAnonymousAccessAllowed")) {
                this.isAnonymousAccessAllowed(model.getIsAnonymousAccessAllowed());
            }
            if (model.wasPropertyExplicitlySet("functionId")) {
                this.functionId(model.getFunctionId());
            }
            if (model.wasPropertyExplicitlySet("tokenHeader")) {
                this.tokenHeader(model.getTokenHeader());
            }
            if (model.wasPropertyExplicitlySet("tokenQueryParam")) {
                this.tokenQueryParam(model.getTokenQueryParam());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("cacheKey")) {
                this.cacheKey(model.getCacheKey());
            }
            if (model.wasPropertyExplicitlySet("validationFailurePolicy")) {
                this.validationFailurePolicy(model.getValidationFailurePolicy());
            }
            return this;
        }
    }
}

