/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.HeaderValidationItem;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HeaderValidationRequestPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="headers")
    private final List<HeaderValidationItem> headers;
    @JsonProperty(value="validationMode")
    private final ValidationMode validationMode;

    @Deprecated
    @ConstructorProperties(value={"headers", "validationMode"})
    public HeaderValidationRequestPolicy(List<HeaderValidationItem> headers, ValidationMode validationMode) {
        this.headers = headers;
        this.validationMode = validationMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<HeaderValidationItem> getHeaders() {
        return this.headers;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HeaderValidationRequestPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("headers=").append(String.valueOf(this.headers));
        sb.append(", validationMode=").append(String.valueOf((Object)this.validationMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderValidationRequestPolicy)) {
            return false;
        }
        HeaderValidationRequestPolicy other = (HeaderValidationRequestPolicy)((Object)o);
        return Objects.equals(this.headers, other.headers) && Objects.equals((Object)this.validationMode, (Object)other.validationMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.validationMode == null ? 43 : this.validationMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ValidationMode implements BmcEnum
    {
        Enforcing("ENFORCING"),
        Permissive("PERMISSIVE"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ValidationMode> map;

        private ValidationMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ValidationMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ValidationMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ValidationMode.class);
            map = new HashMap<String, ValidationMode>();
            for (ValidationMode v : ValidationMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="headers")
        private List<HeaderValidationItem> headers;
        @JsonProperty(value="validationMode")
        private ValidationMode validationMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder headers(List<HeaderValidationItem> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder validationMode(ValidationMode validationMode) {
            this.validationMode = validationMode;
            this.__explicitlySet__.add("validationMode");
            return this;
        }

        public HeaderValidationRequestPolicy build() {
            HeaderValidationRequestPolicy model = new HeaderValidationRequestPolicy(this.headers, this.validationMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HeaderValidationRequestPolicy model) {
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("validationMode")) {
                this.validationMode(model.getValidationMode());
            }
            return this;
        }
    }
}

