/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.ResponseCacheLookupPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SimpleLookupPolicy
extends ResponseCacheLookupPolicy {
    @JsonProperty(value="cacheKeyAdditions")
    private final List<String> cacheKeyAdditions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SimpleLookupPolicy(Boolean isEnabled, Boolean isPrivateCachingEnabled, List<String> cacheKeyAdditions) {
        super(isEnabled, isPrivateCachingEnabled);
        this.cacheKeyAdditions = cacheKeyAdditions;
    }

    public List<String> getCacheKeyAdditions() {
        return this.cacheKeyAdditions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleLookupPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cacheKeyAdditions=").append(String.valueOf(this.cacheKeyAdditions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleLookupPolicy)) {
            return false;
        }
        SimpleLookupPolicy other = (SimpleLookupPolicy)((Object)o);
        return Objects.equals(this.cacheKeyAdditions, other.cacheKeyAdditions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cacheKeyAdditions == null ? 43 : this.cacheKeyAdditions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isPrivateCachingEnabled")
        private Boolean isPrivateCachingEnabled;
        @JsonProperty(value="cacheKeyAdditions")
        private List<String> cacheKeyAdditions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isPrivateCachingEnabled(Boolean isPrivateCachingEnabled) {
            this.isPrivateCachingEnabled = isPrivateCachingEnabled;
            this.__explicitlySet__.add("isPrivateCachingEnabled");
            return this;
        }

        public Builder cacheKeyAdditions(List<String> cacheKeyAdditions) {
            this.cacheKeyAdditions = cacheKeyAdditions;
            this.__explicitlySet__.add("cacheKeyAdditions");
            return this;
        }

        public SimpleLookupPolicy build() {
            SimpleLookupPolicy model = new SimpleLookupPolicy(this.isEnabled, this.isPrivateCachingEnabled, this.cacheKeyAdditions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SimpleLookupPolicy model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isPrivateCachingEnabled")) {
                this.isPrivateCachingEnabled(model.getIsPrivateCachingEnabled());
            }
            if (model.wasPropertyExplicitlySet("cacheKeyAdditions")) {
                this.cacheKeyAdditions(model.getCacheKeyAdditions());
            }
            return this;
        }
    }
}

