/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmconfig.model.ConfigSummary;
import com.oracle.bmc.apmconfig.model.SpanFilterReference;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class SpanFilterSummary
extends ConfigSummary {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="filterText")
    private final String filterText;
    @JsonProperty(value="inUseBy")
    private final List<SpanFilterReference> inUseBy;
    @JsonProperty(value="description")
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SpanFilterSummary(String id, Date timeCreated, Date timeUpdated, String createdBy, String updatedBy, String etag, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String displayName, String filterText, List<SpanFilterReference> inUseBy, String description) {
        super(id, timeCreated, timeUpdated, createdBy, updatedBy, etag, freeformTags, definedTags);
        this.displayName = displayName;
        this.filterText = filterText;
        this.inUseBy = inUseBy;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public List<SpanFilterReference> getInUseBy() {
        return this.inUseBy;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SpanFilterSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", filterText=").append(String.valueOf(this.filterText));
        sb.append(", inUseBy=").append(String.valueOf(this.inUseBy));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanFilterSummary)) {
            return false;
        }
        SpanFilterSummary other = (SpanFilterSummary)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.filterText, other.filterText) && Objects.equals(this.inUseBy, other.inUseBy) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.filterText == null ? 43 : this.filterText.hashCode());
        result = result * 59 + (this.inUseBy == null ? 43 : this.inUseBy.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="updatedBy")
        private String updatedBy;
        @JsonProperty(value="etag")
        private String etag;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="filterText")
        private String filterText;
        @JsonProperty(value="inUseBy")
        private List<SpanFilterReference> inUseBy;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            this.__explicitlySet__.add("updatedBy");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.__explicitlySet__.add("etag");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder filterText(String filterText) {
            this.filterText = filterText;
            this.__explicitlySet__.add("filterText");
            return this;
        }

        public Builder inUseBy(List<SpanFilterReference> inUseBy) {
            this.inUseBy = inUseBy;
            this.__explicitlySet__.add("inUseBy");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public SpanFilterSummary build() {
            SpanFilterSummary model = new SpanFilterSummary(this.id, this.timeCreated, this.timeUpdated, this.createdBy, this.updatedBy, this.etag, this.freeformTags, this.definedTags, this.displayName, this.filterText, this.inUseBy, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SpanFilterSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("updatedBy")) {
                this.updatedBy(model.getUpdatedBy());
            }
            if (model.wasPropertyExplicitlySet("etag")) {
                this.etag(model.getEtag());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("filterText")) {
                this.filterText(model.getFilterText());
            }
            if (model.wasPropertyExplicitlySet("inUseBy")) {
                this.inUseBy(model.getInUseBy());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

