/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmconfig.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListConfigsRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String opcRequestId;
    private String configType;
    private String displayName;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String optionsGroup;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOptionsGroup() {
        return this.optionsGroup;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).opcRequestId(this.opcRequestId).configType(this.configType).displayName(this.displayName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).optionsGroup(this.optionsGroup).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",configType=").append(String.valueOf(this.configType));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",optionsGroup=").append(String.valueOf(this.optionsGroup));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListConfigsRequest)) {
            return false;
        }
        ListConfigsRequest other = (ListConfigsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.configType, other.configType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.optionsGroup, other.optionsGroup) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.configType == null ? 43 : this.configType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.optionsGroup == null ? 43 : this.optionsGroup.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListConfigsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String opcRequestId = null;
        private String configType = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String optionsGroup = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder optionsGroup(String optionsGroup) {
            this.optionsGroup = optionsGroup;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListConfigsRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.opcRequestId(o.getOpcRequestId());
            this.configType(o.getConfigType());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.optionsGroup(o.getOptionsGroup());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListConfigsRequest build() {
            ListConfigsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListConfigsRequest buildWithoutInvocationCallback() {
            ListConfigsRequest request = new ListConfigsRequest();
            request.apmDomainId = this.apmDomainId;
            request.opcRequestId = this.opcRequestId;
            request.configType = this.configType;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.optionsGroup = this.optionsGroup;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

