/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmconfig.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmconfig.model.TestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class TestRequest
extends BmcRequest<TestDetails> {
    private String apmDomainId;
    private TestDetails testDetails;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public TestDetails getTestDetails() {
        return this.testDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public TestDetails getBody$() {
        return this.testDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).testDetails(this.testDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",testDetails=").append(String.valueOf((Object)this.testDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestRequest)) {
            return false;
        }
        TestRequest other = (TestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.testDetails, (Object)other.testDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.testDetails == null ? 43 : this.testDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<TestRequest, TestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private TestDetails testDetails = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder testDetails(TestDetails testDetails) {
            this.testDetails = testDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TestRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.testDetails(o.getTestDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TestRequest build() {
            TestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(TestDetails body) {
            this.testDetails(body);
            return this;
        }

        public TestRequest buildWithoutInvocationCallback() {
            TestRequest request = new TestRequest();
            request.apmDomainId = this.apmDomainId;
            request.testDetails = this.testDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

