/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmcontrolplane.model.RemoveDataKeyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class RemoveDataKeysRequest
extends BmcRequest<List<RemoveDataKeyDetails>> {
    private String apmDomainId;
    private List<RemoveDataKeyDetails> removeDataKeysListDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public List<RemoveDataKeyDetails> getRemoveDataKeysListDetails() {
        return this.removeDataKeysListDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public List<RemoveDataKeyDetails> getBody$() {
        return this.removeDataKeysListDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).removeDataKeysListDetails(this.removeDataKeysListDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",removeDataKeysListDetails=").append(String.valueOf(this.removeDataKeysListDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveDataKeysRequest)) {
            return false;
        }
        RemoveDataKeysRequest other = (RemoveDataKeysRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.removeDataKeysListDetails, other.removeDataKeysListDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.removeDataKeysListDetails == null ? 43 : this.removeDataKeysListDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveDataKeysRequest, List<RemoveDataKeyDetails>> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private List<RemoveDataKeyDetails> removeDataKeysListDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder removeDataKeysListDetails(List<RemoveDataKeyDetails> removeDataKeysListDetails) {
            this.removeDataKeysListDetails = removeDataKeysListDetails;
            return this;
        }

        public Builder removeDataKeysListDetails(RemoveDataKeyDetails singularValue) {
            return this.removeDataKeysListDetails(Arrays.asList(singularValue));
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveDataKeysRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.removeDataKeysListDetails(o.getRemoveDataKeysListDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveDataKeysRequest build() {
            RemoveDataKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(List<RemoveDataKeyDetails> body) {
            this.removeDataKeysListDetails(body);
            return this;
        }

        public RemoveDataKeysRequest buildWithoutInvocationCallback() {
            RemoveDataKeysRequest request = new RemoveDataKeysRequest();
            request.apmDomainId = this.apmDomainId;
            request.removeDataKeysListDetails = this.removeDataKeysListDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

