/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane;

import com.oracle.bmc.apmcontrolplane.ApmDomain;
import com.oracle.bmc.apmcontrolplane.model.LifecycleStates;
import com.oracle.bmc.apmcontrolplane.requests.GetApmDomainRequest;
import com.oracle.bmc.apmcontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.apmcontrolplane.responses.GetApmDomainResponse;
import com.oracle.bmc.apmcontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ApmDomainWaiters {
    private final ExecutorService executorService;
    private final ApmDomain client;

    public ApmDomainWaiters(ExecutorService executorService, ApmDomain client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetApmDomainRequest, GetApmDomainResponse> forApmDomain(GetApmDomainRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApmDomain(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApmDomainRequest, GetApmDomainResponse> forApmDomain(GetApmDomainRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApmDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApmDomainRequest, GetApmDomainResponse> forApmDomain(GetApmDomainRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApmDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApmDomainRequest, GetApmDomainResponse> forApmDomain(BmcGenericWaiter waiter, GetApmDomainRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApmDomainRequest, GetApmDomainResponse>(){

            @Override
            public GetApmDomainResponse apply(GetApmDomainRequest request) {
                return ApmDomainWaiters.this.client.getApmDomain(request);
            }
        }, (Predicate)new Predicate<GetApmDomainResponse>(){

            @Override
            public boolean test(GetApmDomainResponse response) {
                return targetStatesSet.contains((Object)response.getApmDomain().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ApmDomainWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

