/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmcontrolplane.requests;

import com.oracle.bmc.apmcontrolplane.model.DataKeyTypes;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListDataKeysRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private DataKeyTypes dataKeyType;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public DataKeyTypes getDataKeyType() {
        return this.dataKeyType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).dataKeyType(this.dataKeyType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",dataKeyType=").append(String.valueOf((Object)this.dataKeyType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDataKeysRequest)) {
            return false;
        }
        ListDataKeysRequest other = (ListDataKeysRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.dataKeyType, (Object)other.dataKeyType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.dataKeyType == null ? 43 : this.dataKeyType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDataKeysRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private DataKeyTypes dataKeyType = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder dataKeyType(DataKeyTypes dataKeyType) {
            this.dataKeyType = dataKeyType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDataKeysRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.dataKeyType(o.getDataKeyType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDataKeysRequest build() {
            ListDataKeysRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDataKeysRequest buildWithoutInvocationCallback() {
            ListDataKeysRequest request = new ListDataKeysRequest();
            request.apmDomainId = this.apmDomainId;
            request.dataKeyType = this.dataKeyType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

