/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmsynthetics.ApmSyntheticAsync;
import com.oracle.bmc.apmsynthetics.model.AggregatedNetworkDataResult;
import com.oracle.bmc.apmsynthetics.model.DedicatedVantagePoint;
import com.oracle.bmc.apmsynthetics.model.DedicatedVantagePointCollection;
import com.oracle.bmc.apmsynthetics.model.Monitor;
import com.oracle.bmc.apmsynthetics.model.MonitorCollection;
import com.oracle.bmc.apmsynthetics.model.MonitorResult;
import com.oracle.bmc.apmsynthetics.model.PublicVantagePointCollection;
import com.oracle.bmc.apmsynthetics.model.Script;
import com.oracle.bmc.apmsynthetics.model.ScriptCollection;
import com.oracle.bmc.apmsynthetics.requests.AggregateNetworkDataRequest;
import com.oracle.bmc.apmsynthetics.requests.CreateDedicatedVantagePointRequest;
import com.oracle.bmc.apmsynthetics.requests.CreateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.CreateScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteDedicatedVantagePointRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.DeleteScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.GetDedicatedVantagePointRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.GetMonitorResultRequest;
import com.oracle.bmc.apmsynthetics.requests.GetScriptRequest;
import com.oracle.bmc.apmsynthetics.requests.ListDedicatedVantagePointsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListMonitorsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListPublicVantagePointsRequest;
import com.oracle.bmc.apmsynthetics.requests.ListScriptsRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateDedicatedVantagePointRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateMonitorRequest;
import com.oracle.bmc.apmsynthetics.requests.UpdateScriptRequest;
import com.oracle.bmc.apmsynthetics.responses.AggregateNetworkDataResponse;
import com.oracle.bmc.apmsynthetics.responses.CreateDedicatedVantagePointResponse;
import com.oracle.bmc.apmsynthetics.responses.CreateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.CreateScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteDedicatedVantagePointResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.DeleteScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.GetDedicatedVantagePointResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.GetMonitorResultResponse;
import com.oracle.bmc.apmsynthetics.responses.GetScriptResponse;
import com.oracle.bmc.apmsynthetics.responses.ListDedicatedVantagePointsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListMonitorsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListPublicVantagePointsResponse;
import com.oracle.bmc.apmsynthetics.responses.ListScriptsResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateDedicatedVantagePointResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateMonitorResponse;
import com.oracle.bmc.apmsynthetics.responses.UpdateScriptResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmSyntheticAsyncClient
extends BaseAsyncClient
implements ApmSyntheticAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APMSYNTHETIC").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-synthetic.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApmSyntheticAsyncClient.class);

    ApmSyntheticAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AggregateNetworkDataResponse> aggregateNetworkData(AggregateNetworkDataRequest request, AsyncHandler<AggregateNetworkDataRequest, AggregateNetworkDataResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAggregateNetworkDataDetails(), "aggregateNetworkDataDetails is required");
        return this.clientCall(request, AggregateNetworkDataResponse::builder).logger(LOG, "aggregateNetworkData").serviceDetails("ApmSynthetic", "AggregateNetworkData", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/AggregatedNetworkDataResult/AggregateNetworkData").method(Method.POST).requestBuilder(AggregateNetworkDataRequest::builder).basePath("/20200630").appendPathParam("monitors").appendPathParam(request.getMonitorId()).appendPathParam("actions").appendPathParam("aggregateNetworkData").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AggregatedNetworkDataResult.class, AggregateNetworkDataResponse.Builder::aggregatedNetworkDataResult).handleResponseHeaderString("etag", AggregateNetworkDataResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AggregateNetworkDataResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDedicatedVantagePointResponse> createDedicatedVantagePoint(CreateDedicatedVantagePointRequest request, AsyncHandler<CreateDedicatedVantagePointRequest, CreateDedicatedVantagePointResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getCreateDedicatedVantagePointDetails(), "createDedicatedVantagePointDetails is required");
        return this.clientCall(request, CreateDedicatedVantagePointResponse::builder).logger(LOG, "createDedicatedVantagePoint").serviceDetails("ApmSynthetic", "CreateDedicatedVantagePoint", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/DedicatedVantagePoint/CreateDedicatedVantagePoint").method(Method.POST).requestBuilder(CreateDedicatedVantagePointRequest::builder).basePath("/20200630").appendPathParam("dedicatedVantagePoints").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DedicatedVantagePoint.class, CreateDedicatedVantagePointResponse.Builder::dedicatedVantagePoint).handleResponseHeaderString("etag", CreateDedicatedVantagePointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDedicatedVantagePointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateMonitorResponse> createMonitor(CreateMonitorRequest request, AsyncHandler<CreateMonitorRequest, CreateMonitorResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getCreateMonitorDetails(), "createMonitorDetails is required");
        return this.clientCall(request, CreateMonitorResponse::builder).logger(LOG, "createMonitor").serviceDetails("ApmSynthetic", "CreateMonitor", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Monitor/CreateMonitor").method(Method.POST).requestBuilder(CreateMonitorRequest::builder).basePath("/20200630").appendPathParam("monitors").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Monitor.class, CreateMonitorResponse.Builder::monitor).handleResponseHeaderString("etag", CreateMonitorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMonitorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateScriptResponse> createScript(CreateScriptRequest request, AsyncHandler<CreateScriptRequest, CreateScriptResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getCreateScriptDetails(), "createScriptDetails is required");
        return this.clientCall(request, CreateScriptResponse::builder).logger(LOG, "createScript").serviceDetails("ApmSynthetic", "CreateScript", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Script/CreateScript").method(Method.POST).requestBuilder(CreateScriptRequest::builder).basePath("/20200630").appendPathParam("scripts").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Script.class, CreateScriptResponse.Builder::script).handleResponseHeaderString("etag", CreateScriptResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateScriptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDedicatedVantagePointResponse> deleteDedicatedVantagePoint(DeleteDedicatedVantagePointRequest request, AsyncHandler<DeleteDedicatedVantagePointRequest, DeleteDedicatedVantagePointResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getDedicatedVantagePointId(), (String)"dedicatedVantagePointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDedicatedVantagePointResponse::builder).logger(LOG, "deleteDedicatedVantagePoint").serviceDetails("ApmSynthetic", "DeleteDedicatedVantagePoint", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/DedicatedVantagePoint/DeleteDedicatedVantagePoint").method(Method.DELETE).requestBuilder(DeleteDedicatedVantagePointRequest::builder).basePath("/20200630").appendPathParam("dedicatedVantagePoints").appendPathParam(request.getDedicatedVantagePointId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDedicatedVantagePointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest request, AsyncHandler<DeleteMonitorRequest, DeleteMonitorResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMonitorResponse::builder).logger(LOG, "deleteMonitor").serviceDetails("ApmSynthetic", "DeleteMonitor", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Monitor/DeleteMonitor").method(Method.DELETE).requestBuilder(DeleteMonitorRequest::builder).basePath("/20200630").appendPathParam("monitors").appendPathParam(request.getMonitorId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMonitorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteScriptResponse> deleteScript(DeleteScriptRequest request, AsyncHandler<DeleteScriptRequest, DeleteScriptResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getScriptId(), (String)"scriptId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteScriptResponse::builder).logger(LOG, "deleteScript").serviceDetails("ApmSynthetic", "DeleteScript", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Script/DeleteScript").method(Method.DELETE).requestBuilder(DeleteScriptRequest::builder).basePath("/20200630").appendPathParam("scripts").appendPathParam(request.getScriptId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteScriptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDedicatedVantagePointResponse> getDedicatedVantagePoint(GetDedicatedVantagePointRequest request, AsyncHandler<GetDedicatedVantagePointRequest, GetDedicatedVantagePointResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getDedicatedVantagePointId(), (String)"dedicatedVantagePointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDedicatedVantagePointResponse::builder).logger(LOG, "getDedicatedVantagePoint").serviceDetails("ApmSynthetic", "GetDedicatedVantagePoint", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/DedicatedVantagePoint/GetDedicatedVantagePoint").method(Method.GET).requestBuilder(GetDedicatedVantagePointRequest::builder).basePath("/20200630").appendPathParam("dedicatedVantagePoints").appendPathParam(request.getDedicatedVantagePointId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedVantagePoint.class, GetDedicatedVantagePointResponse.Builder::dedicatedVantagePoint).handleResponseHeaderString("etag", GetDedicatedVantagePointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDedicatedVantagePointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMonitorResponse> getMonitor(GetMonitorRequest request, AsyncHandler<GetMonitorRequest, GetMonitorResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMonitorResponse::builder).logger(LOG, "getMonitor").serviceDetails("ApmSynthetic", "GetMonitor", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Monitor/GetMonitor").method(Method.GET).requestBuilder(GetMonitorRequest::builder).basePath("/20200630").appendPathParam("monitors").appendPathParam(request.getMonitorId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Monitor.class, GetMonitorResponse.Builder::monitor).handleResponseHeaderString("etag", GetMonitorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMonitorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMonitorResultResponse> getMonitorResult(GetMonitorResultRequest request, AsyncHandler<GetMonitorResultRequest, GetMonitorResultResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getVantagePoint(), "vantagePoint is required");
        Objects.requireNonNull(request.getResultType(), "resultType is required");
        Objects.requireNonNull(request.getResultContentType(), "resultContentType is required");
        Validate.notBlank((String)request.getExecutionTime(), (String)"executionTime must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMonitorResultResponse::builder).logger(LOG, "getMonitorResult").serviceDetails("ApmSynthetic", "GetMonitorResult", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/MonitorResult/GetMonitorResult").method(Method.GET).requestBuilder(GetMonitorResultRequest::builder).basePath("/20200630").appendPathParam("monitors").appendPathParam(request.getMonitorId()).appendPathParam("results").appendPathParam(request.getExecutionTime()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("vantagePoint", (Object)request.getVantagePoint()).appendQueryParam("resultType", (Object)request.getResultType()).appendQueryParam("resultContentType", (Object)request.getResultContentType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MonitorResult.class, GetMonitorResultResponse.Builder::monitorResult).handleResponseHeaderString("opc-request-id", GetMonitorResultResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetScriptResponse> getScript(GetScriptRequest request, AsyncHandler<GetScriptRequest, GetScriptResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getScriptId(), (String)"scriptId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScriptResponse::builder).logger(LOG, "getScript").serviceDetails("ApmSynthetic", "GetScript", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Script/GetScript").method(Method.GET).requestBuilder(GetScriptRequest::builder).basePath("/20200630").appendPathParam("scripts").appendPathParam(request.getScriptId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Script.class, GetScriptResponse.Builder::script).handleResponseHeaderString("etag", GetScriptResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScriptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedVantagePointsResponse> listDedicatedVantagePoints(ListDedicatedVantagePointsRequest request, AsyncHandler<ListDedicatedVantagePointsRequest, ListDedicatedVantagePointsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, ListDedicatedVantagePointsResponse::builder).logger(LOG, "listDedicatedVantagePoints").serviceDetails("ApmSynthetic", "ListDedicatedVantagePoints", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/DedicatedVantagePointCollection/ListDedicatedVantagePoints").method(Method.GET).requestBuilder(ListDedicatedVantagePointsRequest::builder).basePath("/20200630").appendPathParam("dedicatedVantagePoints").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedVantagePointCollection.class, ListDedicatedVantagePointsResponse.Builder::dedicatedVantagePointCollection).handleResponseHeaderString("opc-request-id", ListDedicatedVantagePointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDedicatedVantagePointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMonitorsResponse> listMonitors(ListMonitorsRequest request, AsyncHandler<ListMonitorsRequest, ListMonitorsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, ListMonitorsResponse::builder).logger(LOG, "listMonitors").serviceDetails("ApmSynthetic", "ListMonitors", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/MonitorCollection/ListMonitors").method(Method.GET).requestBuilder(ListMonitorsRequest::builder).basePath("/20200630").appendPathParam("monitors").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("scriptId", (Object)request.getScriptId()).appendQueryParam("vantagePoint", (Object)request.getVantagePoint()).appendQueryParam("monitorType", (Object)request.getMonitorType()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("isMaintenanceWindowActive", (Object)request.getIsMaintenanceWindowActive()).appendQueryParam("isMaintenanceWindowSet", (Object)request.getIsMaintenanceWindowSet()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MonitorCollection.class, ListMonitorsResponse.Builder::monitorCollection).handleResponseHeaderString("opc-request-id", ListMonitorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMonitorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPublicVantagePointsResponse> listPublicVantagePoints(ListPublicVantagePointsRequest request, AsyncHandler<ListPublicVantagePointsRequest, ListPublicVantagePointsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, ListPublicVantagePointsResponse::builder).logger(LOG, "listPublicVantagePoints").serviceDetails("ApmSynthetic", "ListPublicVantagePoints", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/PublicVantagePointCollection/ListPublicVantagePoints").method(Method.GET).requestBuilder(ListPublicVantagePointsRequest::builder).basePath("/20200630").appendPathParam("publicVantagePoints").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PublicVantagePointCollection.class, ListPublicVantagePointsResponse.Builder::publicVantagePointCollection).handleResponseHeaderString("opc-request-id", ListPublicVantagePointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPublicVantagePointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListScriptsResponse> listScripts(ListScriptsRequest request, AsyncHandler<ListScriptsRequest, ListScriptsResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return this.clientCall(request, ListScriptsResponse::builder).logger(LOG, "listScripts").serviceDetails("ApmSynthetic", "ListScripts", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/ScriptCollection/ListScripts").method(Method.GET).requestBuilder(ListScriptsRequest::builder).basePath("/20200630").appendPathParam("scripts").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("contentType", (Object)request.getContentType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScriptCollection.class, ListScriptsResponse.Builder::scriptCollection).handleResponseHeaderString("opc-request-id", ListScriptsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScriptsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateDedicatedVantagePointResponse> updateDedicatedVantagePoint(UpdateDedicatedVantagePointRequest request, AsyncHandler<UpdateDedicatedVantagePointRequest, UpdateDedicatedVantagePointResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getDedicatedVantagePointId(), (String)"dedicatedVantagePointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDedicatedVantagePointDetails(), "updateDedicatedVantagePointDetails is required");
        return this.clientCall(request, UpdateDedicatedVantagePointResponse::builder).logger(LOG, "updateDedicatedVantagePoint").serviceDetails("ApmSynthetic", "UpdateDedicatedVantagePoint", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/DedicatedVantagePoint/UpdateDedicatedVantagePoint").method(Method.PUT).requestBuilder(UpdateDedicatedVantagePointRequest::builder).basePath("/20200630").appendPathParam("dedicatedVantagePoints").appendPathParam(request.getDedicatedVantagePointId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DedicatedVantagePoint.class, UpdateDedicatedVantagePointResponse.Builder::dedicatedVantagePoint).handleResponseHeaderString("etag", UpdateDedicatedVantagePointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDedicatedVantagePointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest request, AsyncHandler<UpdateMonitorRequest, UpdateMonitorResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getMonitorId(), (String)"monitorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMonitorDetails(), "updateMonitorDetails is required");
        return this.clientCall(request, UpdateMonitorResponse::builder).logger(LOG, "updateMonitor").serviceDetails("ApmSynthetic", "UpdateMonitor", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Monitor/UpdateMonitor").method(Method.PUT).requestBuilder(UpdateMonitorRequest::builder).basePath("/20200630").appendPathParam("monitors").appendPathParam(request.getMonitorId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Monitor.class, UpdateMonitorResponse.Builder::monitor).handleResponseHeaderString("etag", UpdateMonitorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMonitorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateScriptResponse> updateScript(UpdateScriptRequest request, AsyncHandler<UpdateScriptRequest, UpdateScriptResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getScriptId(), (String)"scriptId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateScriptDetails(), "updateScriptDetails is required");
        return this.clientCall(request, UpdateScriptResponse::builder).logger(LOG, "updateScript").serviceDetails("ApmSynthetic", "UpdateScript", "https://docs.oracle.com/iaas/api/#/en/apm-synthetic-monitoring/20200630/Script/UpdateScript").method(Method.PUT).requestBuilder(UpdateScriptRequest::builder).basePath("/20200630").appendPathParam("scripts").appendPathParam(request.getScriptId()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Script.class, UpdateScriptResponse.Builder::script).handleResponseHeaderString("etag", UpdateScriptResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateScriptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApmSyntheticAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApmSyntheticAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApmSyntheticAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApmSyntheticAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApmSyntheticAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApmSyntheticAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ApmSyntheticAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApmSyntheticAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApmSyntheticAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ApmSyntheticAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApmSyntheticAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

