/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Node
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="geoInfo")
    private final String geoInfo;
    @JsonProperty(value="outgoingLinks")
    private final List<String> outgoingLinks;
    @JsonProperty(value="consecutiveAnonymousCount")
    private final Integer consecutiveAnonymousCount;
    @JsonProperty(value="level")
    private final Integer level;
    @JsonProperty(value="avgPacketResponseTimeInMs")
    private final Double avgPacketResponseTimeInMs;
    @JsonProperty(value="avgPacketLossPercent")
    private final Double avgPacketLossPercent;
    @JsonProperty(value="type")
    private final Type type;

    @Deprecated
    @ConstructorProperties(value={"id", "ipAddress", "displayName", "geoInfo", "outgoingLinks", "consecutiveAnonymousCount", "level", "avgPacketResponseTimeInMs", "avgPacketLossPercent", "type"})
    public Node(String id, String ipAddress, String displayName, String geoInfo, List<String> outgoingLinks, Integer consecutiveAnonymousCount, Integer level, Double avgPacketResponseTimeInMs, Double avgPacketLossPercent, Type type) {
        this.id = id;
        this.ipAddress = ipAddress;
        this.displayName = displayName;
        this.geoInfo = geoInfo;
        this.outgoingLinks = outgoingLinks;
        this.consecutiveAnonymousCount = consecutiveAnonymousCount;
        this.level = level;
        this.avgPacketResponseTimeInMs = avgPacketResponseTimeInMs;
        this.avgPacketLossPercent = avgPacketLossPercent;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGeoInfo() {
        return this.geoInfo;
    }

    public List<String> getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public Integer getConsecutiveAnonymousCount() {
        return this.consecutiveAnonymousCount;
    }

    public Integer getLevel() {
        return this.level;
    }

    public Double getAvgPacketResponseTimeInMs() {
        return this.avgPacketResponseTimeInMs;
    }

    public Double getAvgPacketLossPercent() {
        return this.avgPacketLossPercent;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Node(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", geoInfo=").append(String.valueOf(this.geoInfo));
        sb.append(", outgoingLinks=").append(String.valueOf(this.outgoingLinks));
        sb.append(", consecutiveAnonymousCount=").append(String.valueOf(this.consecutiveAnonymousCount));
        sb.append(", level=").append(String.valueOf(this.level));
        sb.append(", avgPacketResponseTimeInMs=").append(String.valueOf(this.avgPacketResponseTimeInMs));
        sb.append(", avgPacketLossPercent=").append(String.valueOf(this.avgPacketLossPercent));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.geoInfo, other.geoInfo) && Objects.equals(this.outgoingLinks, other.outgoingLinks) && Objects.equals(this.consecutiveAnonymousCount, other.consecutiveAnonymousCount) && Objects.equals(this.level, other.level) && Objects.equals(this.avgPacketResponseTimeInMs, other.avgPacketResponseTimeInMs) && Objects.equals(this.avgPacketLossPercent, other.avgPacketLossPercent) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.geoInfo == null ? 43 : this.geoInfo.hashCode());
        result = result * 59 + (this.outgoingLinks == null ? 43 : this.outgoingLinks.hashCode());
        result = result * 59 + (this.consecutiveAnonymousCount == null ? 43 : this.consecutiveAnonymousCount.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        result = result * 59 + (this.avgPacketResponseTimeInMs == null ? 43 : this.avgPacketResponseTimeInMs.hashCode());
        result = result * 59 + (this.avgPacketLossPercent == null ? 43 : this.avgPacketLossPercent.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Source("SOURCE"),
        Destination("DESTINATION"),
        Anonymous("ANONYMOUS"),
        Internal("INTERNAL"),
        Dangling("DANGLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="geoInfo")
        private String geoInfo;
        @JsonProperty(value="outgoingLinks")
        private List<String> outgoingLinks;
        @JsonProperty(value="consecutiveAnonymousCount")
        private Integer consecutiveAnonymousCount;
        @JsonProperty(value="level")
        private Integer level;
        @JsonProperty(value="avgPacketResponseTimeInMs")
        private Double avgPacketResponseTimeInMs;
        @JsonProperty(value="avgPacketLossPercent")
        private Double avgPacketLossPercent;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder geoInfo(String geoInfo) {
            this.geoInfo = geoInfo;
            this.__explicitlySet__.add("geoInfo");
            return this;
        }

        public Builder outgoingLinks(List<String> outgoingLinks) {
            this.outgoingLinks = outgoingLinks;
            this.__explicitlySet__.add("outgoingLinks");
            return this;
        }

        public Builder consecutiveAnonymousCount(Integer consecutiveAnonymousCount) {
            this.consecutiveAnonymousCount = consecutiveAnonymousCount;
            this.__explicitlySet__.add("consecutiveAnonymousCount");
            return this;
        }

        public Builder level(Integer level) {
            this.level = level;
            this.__explicitlySet__.add("level");
            return this;
        }

        public Builder avgPacketResponseTimeInMs(Double avgPacketResponseTimeInMs) {
            this.avgPacketResponseTimeInMs = avgPacketResponseTimeInMs;
            this.__explicitlySet__.add("avgPacketResponseTimeInMs");
            return this;
        }

        public Builder avgPacketLossPercent(Double avgPacketLossPercent) {
            this.avgPacketLossPercent = avgPacketLossPercent;
            this.__explicitlySet__.add("avgPacketLossPercent");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Node build() {
            Node model = new Node(this.id, this.ipAddress, this.displayName, this.geoInfo, this.outgoingLinks, this.consecutiveAnonymousCount, this.level, this.avgPacketResponseTimeInMs, this.avgPacketLossPercent, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Node model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("geoInfo")) {
                this.geoInfo(model.getGeoInfo());
            }
            if (model.wasPropertyExplicitlySet("outgoingLinks")) {
                this.outgoingLinks(model.getOutgoingLinks());
            }
            if (model.wasPropertyExplicitlySet("consecutiveAnonymousCount")) {
                this.consecutiveAnonymousCount(model.getConsecutiveAnonymousCount());
            }
            if (model.wasPropertyExplicitlySet("level")) {
                this.level(model.getLevel());
            }
            if (model.wasPropertyExplicitlySet("avgPacketResponseTimeInMs")) {
                this.avgPacketResponseTimeInMs(model.getAvgPacketResponseTimeInMs());
            }
            if (model.wasPropertyExplicitlySet("avgPacketLossPercent")) {
                this.avgPacketLossPercent(model.getAvgPacketLossPercent());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }
}

