/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmsynthetics.model.CreateScriptDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateScriptRequest
extends BmcRequest<CreateScriptDetails> {
    private String apmDomainId;
    private CreateScriptDetails createScriptDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public CreateScriptDetails getCreateScriptDetails() {
        return this.createScriptDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateScriptDetails getBody$() {
        return this.createScriptDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).createScriptDetails(this.createScriptDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",createScriptDetails=").append(String.valueOf((Object)this.createScriptDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateScriptRequest)) {
            return false;
        }
        CreateScriptRequest other = (CreateScriptRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals((Object)this.createScriptDetails, (Object)other.createScriptDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.createScriptDetails == null ? 43 : this.createScriptDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateScriptRequest, CreateScriptDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private CreateScriptDetails createScriptDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder createScriptDetails(CreateScriptDetails createScriptDetails) {
            this.createScriptDetails = createScriptDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateScriptRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.createScriptDetails(o.getCreateScriptDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateScriptRequest build() {
            CreateScriptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateScriptDetails body) {
            this.createScriptDetails(body);
            return this;
        }

        public CreateScriptRequest buildWithoutInvocationCallback() {
            CreateScriptRequest request = new CreateScriptRequest();
            request.apmDomainId = this.apmDomainId;
            request.createScriptDetails = this.createScriptDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

