/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.Link;
import com.oracle.bmc.apmsynthetics.model.Node;
import com.oracle.bmc.apmsynthetics.model.VantagePointNode;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AggregatedNetworkData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resultState")
    private final ResultState resultState;
    @JsonProperty(value="vantagePointNodes")
    private final List<VantagePointNode> vantagePointNodes;
    @JsonProperty(value="nodesByLevel")
    private final List<List<Node>> nodesByLevel;
    @JsonProperty(value="links")
    private final Map<String, Link> links;
    @JsonProperty(value="errorDetails")
    private final String errorDetails;

    @Deprecated
    @ConstructorProperties(value={"resultState", "vantagePointNodes", "nodesByLevel", "links", "errorDetails"})
    public AggregatedNetworkData(ResultState resultState, List<VantagePointNode> vantagePointNodes, List<List<Node>> nodesByLevel, Map<String, Link> links, String errorDetails) {
        this.resultState = resultState;
        this.vantagePointNodes = vantagePointNodes;
        this.nodesByLevel = nodesByLevel;
        this.links = links;
        this.errorDetails = errorDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public List<VantagePointNode> getVantagePointNodes() {
        return this.vantagePointNodes;
    }

    public List<List<Node>> getNodesByLevel() {
        return this.nodesByLevel;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AggregatedNetworkData(");
        sb.append("super=").append(super.toString());
        sb.append("resultState=").append(String.valueOf((Object)this.resultState));
        sb.append(", vantagePointNodes=").append(String.valueOf(this.vantagePointNodes));
        sb.append(", nodesByLevel=").append(String.valueOf(this.nodesByLevel));
        sb.append(", links=").append(String.valueOf(this.links));
        sb.append(", errorDetails=").append(String.valueOf(this.errorDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedNetworkData)) {
            return false;
        }
        AggregatedNetworkData other = (AggregatedNetworkData)((Object)o);
        return Objects.equals((Object)this.resultState, (Object)other.resultState) && Objects.equals(this.vantagePointNodes, other.vantagePointNodes) && Objects.equals(this.nodesByLevel, other.nodesByLevel) && Objects.equals(this.links, other.links) && Objects.equals(this.errorDetails, other.errorDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resultState == null ? 43 : this.resultState.hashCode());
        result = result * 59 + (this.vantagePointNodes == null ? 43 : this.vantagePointNodes.hashCode());
        result = result * 59 + (this.nodesByLevel == null ? 43 : this.nodesByLevel.hashCode());
        result = result * 59 + (this.links == null ? 43 : this.links.hashCode());
        result = result * 59 + (this.errorDetails == null ? 43 : this.errorDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResultState implements BmcEnum
    {
        Success("SUCCESS"),
        Failure("FAILURE"),
        Partial("PARTIAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResultState> map;

        private ResultState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResultState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResultState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResultState.class);
            map = new HashMap<String, ResultState>();
            for (ResultState v : ResultState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resultState")
        private ResultState resultState;
        @JsonProperty(value="vantagePointNodes")
        private List<VantagePointNode> vantagePointNodes;
        @JsonProperty(value="nodesByLevel")
        private List<List<Node>> nodesByLevel;
        @JsonProperty(value="links")
        private Map<String, Link> links;
        @JsonProperty(value="errorDetails")
        private String errorDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resultState(ResultState resultState) {
            this.resultState = resultState;
            this.__explicitlySet__.add("resultState");
            return this;
        }

        public Builder vantagePointNodes(List<VantagePointNode> vantagePointNodes) {
            this.vantagePointNodes = vantagePointNodes;
            this.__explicitlySet__.add("vantagePointNodes");
            return this;
        }

        public Builder nodesByLevel(List<List<Node>> nodesByLevel) {
            this.nodesByLevel = nodesByLevel;
            this.__explicitlySet__.add("nodesByLevel");
            return this;
        }

        public Builder links(Map<String, Link> links) {
            this.links = links;
            this.__explicitlySet__.add("links");
            return this;
        }

        public Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            this.__explicitlySet__.add("errorDetails");
            return this;
        }

        public AggregatedNetworkData build() {
            AggregatedNetworkData model = new AggregatedNetworkData(this.resultState, this.vantagePointNodes, this.nodesByLevel, this.links, this.errorDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AggregatedNetworkData model) {
            if (model.wasPropertyExplicitlySet("resultState")) {
                this.resultState(model.getResultState());
            }
            if (model.wasPropertyExplicitlySet("vantagePointNodes")) {
                this.vantagePointNodes(model.getVantagePointNodes());
            }
            if (model.wasPropertyExplicitlySet("nodesByLevel")) {
                this.nodesByLevel(model.getNodesByLevel());
            }
            if (model.wasPropertyExplicitlySet("links")) {
                this.links(model.getLinks());
            }
            if (model.wasPropertyExplicitlySet("errorDetails")) {
                this.errorDetails(model.getErrorDetails());
            }
            return this;
        }
    }
}

