/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsRecordType;
import com.oracle.bmc.apmsynthetics.model.DnsTransportProtocol;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class DnsTraceMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="recordType")
    private final DnsRecordType recordType;
    @JsonProperty(value="protocol")
    private final DnsTransportProtocol protocol;
    @JsonProperty(value="verifyResponseContent")
    private final String verifyResponseContent;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DnsTraceMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, DnsRecordType recordType, DnsTransportProtocol protocol, String verifyResponseContent) {
        super(isFailureRetried, dnsConfiguration);
        this.recordType = recordType;
        this.protocol = protocol;
        this.verifyResponseContent = verifyResponseContent;
    }

    public DnsRecordType getRecordType() {
        return this.recordType;
    }

    public DnsTransportProtocol getProtocol() {
        return this.protocol;
    }

    public String getVerifyResponseContent() {
        return this.verifyResponseContent;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DnsTraceMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", recordType=").append(String.valueOf((Object)this.recordType));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", verifyResponseContent=").append(String.valueOf(this.verifyResponseContent));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnsTraceMonitorConfiguration)) {
            return false;
        }
        DnsTraceMonitorConfiguration other = (DnsTraceMonitorConfiguration)((Object)o);
        return Objects.equals((Object)this.recordType, (Object)other.recordType) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.verifyResponseContent, other.verifyResponseContent) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recordType == null ? 43 : this.recordType.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.verifyResponseContent == null ? 43 : this.verifyResponseContent.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="recordType")
        private DnsRecordType recordType;
        @JsonProperty(value="protocol")
        private DnsTransportProtocol protocol;
        @JsonProperty(value="verifyResponseContent")
        private String verifyResponseContent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder recordType(DnsRecordType recordType) {
            this.recordType = recordType;
            this.__explicitlySet__.add("recordType");
            return this;
        }

        public Builder protocol(DnsTransportProtocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder verifyResponseContent(String verifyResponseContent) {
            this.verifyResponseContent = verifyResponseContent;
            this.__explicitlySet__.add("verifyResponseContent");
            return this;
        }

        public DnsTraceMonitorConfiguration build() {
            DnsTraceMonitorConfiguration model = new DnsTraceMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.recordType, this.protocol, this.verifyResponseContent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DnsTraceMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("recordType")) {
                this.recordType(model.getRecordType());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseContent")) {
                this.verifyResponseContent(model.getVerifyResponseContent());
            }
            return this;
        }
    }
}

