/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import com.oracle.bmc.apmsynthetics.model.RequestAuthenticationSchemesForScriptedRest;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class ScriptedRestMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="reqAuthenticationScheme")
    private final RequestAuthenticationSchemesForScriptedRest reqAuthenticationScheme;
    @JsonProperty(value="verifyResponseCodes")
    private final List<String> verifyResponseCodes;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScriptedRestMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, RequestAuthenticationSchemesForScriptedRest reqAuthenticationScheme, List<String> verifyResponseCodes, NetworkConfiguration networkConfiguration) {
        super(isFailureRetried, dnsConfiguration);
        this.reqAuthenticationScheme = reqAuthenticationScheme;
        this.verifyResponseCodes = verifyResponseCodes;
        this.networkConfiguration = networkConfiguration;
    }

    public RequestAuthenticationSchemesForScriptedRest getReqAuthenticationScheme() {
        return this.reqAuthenticationScheme;
    }

    public List<String> getVerifyResponseCodes() {
        return this.verifyResponseCodes;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScriptedRestMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", reqAuthenticationScheme=").append(String.valueOf((Object)this.reqAuthenticationScheme));
        sb.append(", verifyResponseCodes=").append(String.valueOf(this.verifyResponseCodes));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptedRestMonitorConfiguration)) {
            return false;
        }
        ScriptedRestMonitorConfiguration other = (ScriptedRestMonitorConfiguration)((Object)o);
        return Objects.equals((Object)this.reqAuthenticationScheme, (Object)other.reqAuthenticationScheme) && Objects.equals(this.verifyResponseCodes, other.verifyResponseCodes) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reqAuthenticationScheme == null ? 43 : this.reqAuthenticationScheme.hashCode());
        result = result * 59 + (this.verifyResponseCodes == null ? 43 : this.verifyResponseCodes.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="reqAuthenticationScheme")
        private RequestAuthenticationSchemesForScriptedRest reqAuthenticationScheme;
        @JsonProperty(value="verifyResponseCodes")
        private List<String> verifyResponseCodes;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder reqAuthenticationScheme(RequestAuthenticationSchemesForScriptedRest reqAuthenticationScheme) {
            this.reqAuthenticationScheme = reqAuthenticationScheme;
            this.__explicitlySet__.add("reqAuthenticationScheme");
            return this;
        }

        public Builder verifyResponseCodes(List<String> verifyResponseCodes) {
            this.verifyResponseCodes = verifyResponseCodes;
            this.__explicitlySet__.add("verifyResponseCodes");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public ScriptedRestMonitorConfiguration build() {
            ScriptedRestMonitorConfiguration model = new ScriptedRestMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.reqAuthenticationScheme, this.verifyResponseCodes, this.networkConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScriptedRestMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("reqAuthenticationScheme")) {
                this.reqAuthenticationScheme(model.getReqAuthenticationScheme());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseCodes")) {
                this.verifyResponseCodes(model.getVerifyResponseCodes());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            return this;
        }
    }
}

