/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apmsynthetics.model.CreateWorkerDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateWorkerRequest
extends BmcRequest<CreateWorkerDetails> {
    private String apmDomainId;
    private String onPremiseVantagePointId;
    private CreateWorkerDetails createWorkerDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getOnPremiseVantagePointId() {
        return this.onPremiseVantagePointId;
    }

    public CreateWorkerDetails getCreateWorkerDetails() {
        return this.createWorkerDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateWorkerDetails getBody$() {
        return this.createWorkerDetails;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).onPremiseVantagePointId(this.onPremiseVantagePointId).createWorkerDetails(this.createWorkerDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",onPremiseVantagePointId=").append(String.valueOf(this.onPremiseVantagePointId));
        sb.append(",createWorkerDetails=").append(String.valueOf((Object)this.createWorkerDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateWorkerRequest)) {
            return false;
        }
        CreateWorkerRequest other = (CreateWorkerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.onPremiseVantagePointId, other.onPremiseVantagePointId) && Objects.equals((Object)this.createWorkerDetails, (Object)other.createWorkerDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.onPremiseVantagePointId == null ? 43 : this.onPremiseVantagePointId.hashCode());
        result = result * 59 + (this.createWorkerDetails == null ? 43 : this.createWorkerDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateWorkerRequest, CreateWorkerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String onPremiseVantagePointId = null;
        private CreateWorkerDetails createWorkerDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder onPremiseVantagePointId(String onPremiseVantagePointId) {
            this.onPremiseVantagePointId = onPremiseVantagePointId;
            return this;
        }

        public Builder createWorkerDetails(CreateWorkerDetails createWorkerDetails) {
            this.createWorkerDetails = createWorkerDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateWorkerRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.onPremiseVantagePointId(o.getOnPremiseVantagePointId());
            this.createWorkerDetails(o.getCreateWorkerDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateWorkerRequest build() {
            CreateWorkerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateWorkerDetails body) {
            this.createWorkerDetails(body);
            return this;
        }

        public CreateWorkerRequest buildWithoutInvocationCallback() {
            CreateWorkerRequest request = new CreateWorkerRequest();
            request.apmDomainId = this.apmDomainId;
            request.onPremiseVantagePointId = this.onPremiseVantagePointId;
            request.createWorkerDetails = this.createWorkerDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

