/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmsynthetics.model.OnPremiseVantagePointWorkerStatus;
import com.oracle.bmc.apmsynthetics.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListWorkersRequest
extends BmcRequest<Void> {
    private String apmDomainId;
    private String onPremiseVantagePointId;
    private Integer limit;
    private String page;
    private OnPremiseVantagePointWorkerStatus status;
    private String capability;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String displayName;
    private String name;
    private String opcRequestId;

    public String getApmDomainId() {
        return this.apmDomainId;
    }

    public String getOnPremiseVantagePointId() {
        return this.onPremiseVantagePointId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public OnPremiseVantagePointWorkerStatus getStatus() {
        return this.status;
    }

    public String getCapability() {
        return this.capability;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().apmDomainId(this.apmDomainId).onPremiseVantagePointId(this.onPremiseVantagePointId).limit(this.limit).page(this.page).status(this.status).capability(this.capability).sortOrder(this.sortOrder).sortBy(this.sortBy).displayName(this.displayName).name(this.name).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apmDomainId=").append(String.valueOf(this.apmDomainId));
        sb.append(",onPremiseVantagePointId=").append(String.valueOf(this.onPremiseVantagePointId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",capability=").append(String.valueOf(this.capability));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWorkersRequest)) {
            return false;
        }
        ListWorkersRequest other = (ListWorkersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apmDomainId, other.apmDomainId) && Objects.equals(this.onPremiseVantagePointId, other.onPremiseVantagePointId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.capability, other.capability) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apmDomainId == null ? 43 : this.apmDomainId.hashCode());
        result = result * 59 + (this.onPremiseVantagePointId == null ? 43 : this.onPremiseVantagePointId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.capability == null ? 43 : this.capability.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apmDomainId = null;
        private String onPremiseVantagePointId = null;
        private Integer limit = null;
        private String page = null;
        private OnPremiseVantagePointWorkerStatus status = null;
        private String capability = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String displayName = null;
        private String name = null;
        private String opcRequestId = null;

        public Builder apmDomainId(String apmDomainId) {
            this.apmDomainId = apmDomainId;
            return this;
        }

        public Builder onPremiseVantagePointId(String onPremiseVantagePointId) {
            this.onPremiseVantagePointId = onPremiseVantagePointId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder status(OnPremiseVantagePointWorkerStatus status) {
            this.status = status;
            return this;
        }

        public Builder capability(String capability) {
            this.capability = capability;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkersRequest o) {
            this.apmDomainId(o.getApmDomainId());
            this.onPremiseVantagePointId(o.getOnPremiseVantagePointId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.status(o.getStatus());
            this.capability(o.getCapability());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.displayName(o.getDisplayName());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkersRequest build() {
            ListWorkersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWorkersRequest buildWithoutInvocationCallback() {
            ListWorkersRequest request = new ListWorkersRequest();
            request.apmDomainId = this.apmDomainId;
            request.onPremiseVantagePointId = this.onPremiseVantagePointId;
            request.limit = this.limit;
            request.page = this.page;
            request.status = this.status;
            request.capability = this.capability;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.displayName = this.displayName;
            request.name = this.name;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        Name("name"),
        Status("status"),
        Priority("priority"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        TimeLastSyncup("timeLastSyncup");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

