/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.BasicAuthenticationDetails;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.FtpProtocol;
import com.oracle.bmc.apmsynthetics.model.FtpRequestType;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class FtpMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="ftpProtocol")
    private final FtpProtocol ftpProtocol;
    @JsonProperty(value="ftpRequestType")
    private final FtpRequestType ftpRequestType;
    @JsonProperty(value="isActiveMode")
    private final Boolean isActiveMode;
    @JsonProperty(value="ftpBasicAuthenticationDetails")
    private final BasicAuthenticationDetails ftpBasicAuthenticationDetails;
    @JsonProperty(value="downloadSizeLimitInBytes")
    private final Integer downloadSizeLimitInBytes;
    @JsonProperty(value="uploadFileSizeInBytes")
    private final Integer uploadFileSizeInBytes;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;
    @JsonProperty(value="verifyResponseCodes")
    private final List<String> verifyResponseCodes;
    @JsonProperty(value="verifyResponseContent")
    private final String verifyResponseContent;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FtpMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, FtpProtocol ftpProtocol, FtpRequestType ftpRequestType, Boolean isActiveMode, BasicAuthenticationDetails ftpBasicAuthenticationDetails, Integer downloadSizeLimitInBytes, Integer uploadFileSizeInBytes, NetworkConfiguration networkConfiguration, List<String> verifyResponseCodes, String verifyResponseContent) {
        super(isFailureRetried, dnsConfiguration);
        this.ftpProtocol = ftpProtocol;
        this.ftpRequestType = ftpRequestType;
        this.isActiveMode = isActiveMode;
        this.ftpBasicAuthenticationDetails = ftpBasicAuthenticationDetails;
        this.downloadSizeLimitInBytes = downloadSizeLimitInBytes;
        this.uploadFileSizeInBytes = uploadFileSizeInBytes;
        this.networkConfiguration = networkConfiguration;
        this.verifyResponseCodes = verifyResponseCodes;
        this.verifyResponseContent = verifyResponseContent;
    }

    public FtpProtocol getFtpProtocol() {
        return this.ftpProtocol;
    }

    public FtpRequestType getFtpRequestType() {
        return this.ftpRequestType;
    }

    public Boolean getIsActiveMode() {
        return this.isActiveMode;
    }

    public BasicAuthenticationDetails getFtpBasicAuthenticationDetails() {
        return this.ftpBasicAuthenticationDetails;
    }

    public Integer getDownloadSizeLimitInBytes() {
        return this.downloadSizeLimitInBytes;
    }

    public Integer getUploadFileSizeInBytes() {
        return this.uploadFileSizeInBytes;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public List<String> getVerifyResponseCodes() {
        return this.verifyResponseCodes;
    }

    public String getVerifyResponseContent() {
        return this.verifyResponseContent;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FtpMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ftpProtocol=").append(String.valueOf((Object)this.ftpProtocol));
        sb.append(", ftpRequestType=").append(String.valueOf((Object)this.ftpRequestType));
        sb.append(", isActiveMode=").append(String.valueOf(this.isActiveMode));
        sb.append(", ftpBasicAuthenticationDetails=").append(String.valueOf((Object)this.ftpBasicAuthenticationDetails));
        sb.append(", downloadSizeLimitInBytes=").append(String.valueOf(this.downloadSizeLimitInBytes));
        sb.append(", uploadFileSizeInBytes=").append(String.valueOf(this.uploadFileSizeInBytes));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(", verifyResponseCodes=").append(String.valueOf(this.verifyResponseCodes));
        sb.append(", verifyResponseContent=").append(String.valueOf(this.verifyResponseContent));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtpMonitorConfiguration)) {
            return false;
        }
        FtpMonitorConfiguration other = (FtpMonitorConfiguration)((Object)o);
        return Objects.equals((Object)this.ftpProtocol, (Object)other.ftpProtocol) && Objects.equals((Object)this.ftpRequestType, (Object)other.ftpRequestType) && Objects.equals(this.isActiveMode, other.isActiveMode) && Objects.equals((Object)this.ftpBasicAuthenticationDetails, (Object)other.ftpBasicAuthenticationDetails) && Objects.equals(this.downloadSizeLimitInBytes, other.downloadSizeLimitInBytes) && Objects.equals(this.uploadFileSizeInBytes, other.uploadFileSizeInBytes) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && Objects.equals(this.verifyResponseCodes, other.verifyResponseCodes) && Objects.equals(this.verifyResponseContent, other.verifyResponseContent) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ftpProtocol == null ? 43 : this.ftpProtocol.hashCode());
        result = result * 59 + (this.ftpRequestType == null ? 43 : this.ftpRequestType.hashCode());
        result = result * 59 + (this.isActiveMode == null ? 43 : this.isActiveMode.hashCode());
        result = result * 59 + (this.ftpBasicAuthenticationDetails == null ? 43 : this.ftpBasicAuthenticationDetails.hashCode());
        result = result * 59 + (this.downloadSizeLimitInBytes == null ? 43 : this.downloadSizeLimitInBytes.hashCode());
        result = result * 59 + (this.uploadFileSizeInBytes == null ? 43 : this.uploadFileSizeInBytes.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + (this.verifyResponseCodes == null ? 43 : this.verifyResponseCodes.hashCode());
        result = result * 59 + (this.verifyResponseContent == null ? 43 : this.verifyResponseContent.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="ftpProtocol")
        private FtpProtocol ftpProtocol;
        @JsonProperty(value="ftpRequestType")
        private FtpRequestType ftpRequestType;
        @JsonProperty(value="isActiveMode")
        private Boolean isActiveMode;
        @JsonProperty(value="ftpBasicAuthenticationDetails")
        private BasicAuthenticationDetails ftpBasicAuthenticationDetails;
        @JsonProperty(value="downloadSizeLimitInBytes")
        private Integer downloadSizeLimitInBytes;
        @JsonProperty(value="uploadFileSizeInBytes")
        private Integer uploadFileSizeInBytes;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonProperty(value="verifyResponseCodes")
        private List<String> verifyResponseCodes;
        @JsonProperty(value="verifyResponseContent")
        private String verifyResponseContent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder ftpProtocol(FtpProtocol ftpProtocol) {
            this.ftpProtocol = ftpProtocol;
            this.__explicitlySet__.add("ftpProtocol");
            return this;
        }

        public Builder ftpRequestType(FtpRequestType ftpRequestType) {
            this.ftpRequestType = ftpRequestType;
            this.__explicitlySet__.add("ftpRequestType");
            return this;
        }

        public Builder isActiveMode(Boolean isActiveMode) {
            this.isActiveMode = isActiveMode;
            this.__explicitlySet__.add("isActiveMode");
            return this;
        }

        public Builder ftpBasicAuthenticationDetails(BasicAuthenticationDetails ftpBasicAuthenticationDetails) {
            this.ftpBasicAuthenticationDetails = ftpBasicAuthenticationDetails;
            this.__explicitlySet__.add("ftpBasicAuthenticationDetails");
            return this;
        }

        public Builder downloadSizeLimitInBytes(Integer downloadSizeLimitInBytes) {
            this.downloadSizeLimitInBytes = downloadSizeLimitInBytes;
            this.__explicitlySet__.add("downloadSizeLimitInBytes");
            return this;
        }

        public Builder uploadFileSizeInBytes(Integer uploadFileSizeInBytes) {
            this.uploadFileSizeInBytes = uploadFileSizeInBytes;
            this.__explicitlySet__.add("uploadFileSizeInBytes");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public Builder verifyResponseCodes(List<String> verifyResponseCodes) {
            this.verifyResponseCodes = verifyResponseCodes;
            this.__explicitlySet__.add("verifyResponseCodes");
            return this;
        }

        public Builder verifyResponseContent(String verifyResponseContent) {
            this.verifyResponseContent = verifyResponseContent;
            this.__explicitlySet__.add("verifyResponseContent");
            return this;
        }

        public FtpMonitorConfiguration build() {
            FtpMonitorConfiguration model = new FtpMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.ftpProtocol, this.ftpRequestType, this.isActiveMode, this.ftpBasicAuthenticationDetails, this.downloadSizeLimitInBytes, this.uploadFileSizeInBytes, this.networkConfiguration, this.verifyResponseCodes, this.verifyResponseContent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FtpMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("ftpProtocol")) {
                this.ftpProtocol(model.getFtpProtocol());
            }
            if (model.wasPropertyExplicitlySet("ftpRequestType")) {
                this.ftpRequestType(model.getFtpRequestType());
            }
            if (model.wasPropertyExplicitlySet("isActiveMode")) {
                this.isActiveMode(model.getIsActiveMode());
            }
            if (model.wasPropertyExplicitlySet("ftpBasicAuthenticationDetails")) {
                this.ftpBasicAuthenticationDetails(model.getFtpBasicAuthenticationDetails());
            }
            if (model.wasPropertyExplicitlySet("downloadSizeLimitInBytes")) {
                this.downloadSizeLimitInBytes(model.getDownloadSizeLimitInBytes());
            }
            if (model.wasPropertyExplicitlySet("uploadFileSizeInBytes")) {
                this.uploadFileSizeInBytes(model.getUploadFileSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseCodes")) {
                this.verifyResponseCodes(model.getVerifyResponseCodes());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseContent")) {
                this.verifyResponseContent(model.getVerifyResponseContent());
            }
            return this;
        }
    }
}

