/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DvpStackDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dvpStackType")
@JsonFilter(value="explicitlySetFilter")
public final class OracleRMStack
extends DvpStackDetails {
    @JsonProperty(value="dvpStackId")
    private final String dvpStackId;
    @JsonProperty(value="dvpStreamId")
    private final String dvpStreamId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleRMStack(String dvpVersion, String dvpStackId, String dvpStreamId) {
        super(dvpVersion);
        this.dvpStackId = dvpStackId;
        this.dvpStreamId = dvpStreamId;
    }

    public String getDvpStackId() {
        return this.dvpStackId;
    }

    public String getDvpStreamId() {
        return this.dvpStreamId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleRMStack(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dvpStackId=").append(String.valueOf(this.dvpStackId));
        sb.append(", dvpStreamId=").append(String.valueOf(this.dvpStreamId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleRMStack)) {
            return false;
        }
        OracleRMStack other = (OracleRMStack)((Object)o);
        return Objects.equals(this.dvpStackId, other.dvpStackId) && Objects.equals(this.dvpStreamId, other.dvpStreamId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dvpStackId == null ? 43 : this.dvpStackId.hashCode());
        result = result * 59 + (this.dvpStreamId == null ? 43 : this.dvpStreamId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dvpVersion")
        private String dvpVersion;
        @JsonProperty(value="dvpStackId")
        private String dvpStackId;
        @JsonProperty(value="dvpStreamId")
        private String dvpStreamId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dvpVersion(String dvpVersion) {
            this.dvpVersion = dvpVersion;
            this.__explicitlySet__.add("dvpVersion");
            return this;
        }

        public Builder dvpStackId(String dvpStackId) {
            this.dvpStackId = dvpStackId;
            this.__explicitlySet__.add("dvpStackId");
            return this;
        }

        public Builder dvpStreamId(String dvpStreamId) {
            this.dvpStreamId = dvpStreamId;
            this.__explicitlySet__.add("dvpStreamId");
            return this;
        }

        public OracleRMStack build() {
            OracleRMStack model = new OracleRMStack(this.dvpVersion, this.dvpStackId, this.dvpStreamId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleRMStack model) {
            if (model.wasPropertyExplicitlySet("dvpVersion")) {
                this.dvpVersion(model.getDvpVersion());
            }
            if (model.wasPropertyExplicitlySet("dvpStackId")) {
                this.dvpStackId(model.getDvpStackId());
            }
            if (model.wasPropertyExplicitlySet("dvpStreamId")) {
                this.dvpStreamId(model.getDvpStreamId());
            }
            return this;
        }
    }
}

