/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class ScriptedBrowserMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="isCertificateValidationEnabled")
    private final Boolean isCertificateValidationEnabled;
    @JsonProperty(value="isDefaultSnapshotEnabled")
    private final Boolean isDefaultSnapshotEnabled;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ScriptedBrowserMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, Boolean isCertificateValidationEnabled, Boolean isDefaultSnapshotEnabled, NetworkConfiguration networkConfiguration) {
        super(isFailureRetried, dnsConfiguration);
        this.isCertificateValidationEnabled = isCertificateValidationEnabled;
        this.isDefaultSnapshotEnabled = isDefaultSnapshotEnabled;
        this.networkConfiguration = networkConfiguration;
    }

    public Boolean getIsCertificateValidationEnabled() {
        return this.isCertificateValidationEnabled;
    }

    public Boolean getIsDefaultSnapshotEnabled() {
        return this.isDefaultSnapshotEnabled;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScriptedBrowserMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isCertificateValidationEnabled=").append(String.valueOf(this.isCertificateValidationEnabled));
        sb.append(", isDefaultSnapshotEnabled=").append(String.valueOf(this.isDefaultSnapshotEnabled));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptedBrowserMonitorConfiguration)) {
            return false;
        }
        ScriptedBrowserMonitorConfiguration other = (ScriptedBrowserMonitorConfiguration)((Object)o);
        return Objects.equals(this.isCertificateValidationEnabled, other.isCertificateValidationEnabled) && Objects.equals(this.isDefaultSnapshotEnabled, other.isDefaultSnapshotEnabled) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCertificateValidationEnabled == null ? 43 : this.isCertificateValidationEnabled.hashCode());
        result = result * 59 + (this.isDefaultSnapshotEnabled == null ? 43 : this.isDefaultSnapshotEnabled.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="isCertificateValidationEnabled")
        private Boolean isCertificateValidationEnabled;
        @JsonProperty(value="isDefaultSnapshotEnabled")
        private Boolean isDefaultSnapshotEnabled;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder isCertificateValidationEnabled(Boolean isCertificateValidationEnabled) {
            this.isCertificateValidationEnabled = isCertificateValidationEnabled;
            this.__explicitlySet__.add("isCertificateValidationEnabled");
            return this;
        }

        public Builder isDefaultSnapshotEnabled(Boolean isDefaultSnapshotEnabled) {
            this.isDefaultSnapshotEnabled = isDefaultSnapshotEnabled;
            this.__explicitlySet__.add("isDefaultSnapshotEnabled");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public ScriptedBrowserMonitorConfiguration build() {
            ScriptedBrowserMonitorConfiguration model = new ScriptedBrowserMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.isCertificateValidationEnabled, this.isDefaultSnapshotEnabled, this.networkConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScriptedBrowserMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("isCertificateValidationEnabled")) {
                this.isCertificateValidationEnabled(model.getIsCertificateValidationEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDefaultSnapshotEnabled")) {
                this.isDefaultSnapshotEnabled(model.getIsDefaultSnapshotEnabled());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            return this;
        }
    }
}

