/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.BasicAuthenticationDetails;
import com.oracle.bmc.apmsynthetics.model.DatabaseConnectionType;
import com.oracle.bmc.apmsynthetics.model.DatabaseType;
import com.oracle.bmc.apmsynthetics.model.DatabaseWalletDetails;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class SqlMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="databaseAuthenticationDetails")
    private final BasicAuthenticationDetails databaseAuthenticationDetails;
    @JsonProperty(value="databaseRole")
    private final String databaseRole;
    @JsonProperty(value="databaseConnectionType")
    private final DatabaseConnectionType databaseConnectionType;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="databaseWalletDetails")
    private final DatabaseWalletDetails databaseWalletDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SqlMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, DatabaseType databaseType, String query, BasicAuthenticationDetails databaseAuthenticationDetails, String databaseRole, DatabaseConnectionType databaseConnectionType, String connectionString, DatabaseWalletDetails databaseWalletDetails) {
        super(isFailureRetried, dnsConfiguration);
        this.databaseType = databaseType;
        this.query = query;
        this.databaseAuthenticationDetails = databaseAuthenticationDetails;
        this.databaseRole = databaseRole;
        this.databaseConnectionType = databaseConnectionType;
        this.connectionString = connectionString;
        this.databaseWalletDetails = databaseWalletDetails;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getQuery() {
        return this.query;
    }

    public BasicAuthenticationDetails getDatabaseAuthenticationDetails() {
        return this.databaseAuthenticationDetails;
    }

    public String getDatabaseRole() {
        return this.databaseRole;
    }

    public DatabaseConnectionType getDatabaseConnectionType() {
        return this.databaseConnectionType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public DatabaseWalletDetails getDatabaseWalletDetails() {
        return this.databaseWalletDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", databaseAuthenticationDetails=").append(String.valueOf((Object)this.databaseAuthenticationDetails));
        sb.append(", databaseRole=").append(String.valueOf(this.databaseRole));
        sb.append(", databaseConnectionType=").append(String.valueOf((Object)this.databaseConnectionType));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", databaseWalletDetails=").append(String.valueOf((Object)this.databaseWalletDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlMonitorConfiguration)) {
            return false;
        }
        SqlMonitorConfiguration other = (SqlMonitorConfiguration)((Object)o);
        return Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals(this.query, other.query) && Objects.equals((Object)this.databaseAuthenticationDetails, (Object)other.databaseAuthenticationDetails) && Objects.equals(this.databaseRole, other.databaseRole) && Objects.equals((Object)this.databaseConnectionType, (Object)other.databaseConnectionType) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals((Object)this.databaseWalletDetails, (Object)other.databaseWalletDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.databaseAuthenticationDetails == null ? 43 : this.databaseAuthenticationDetails.hashCode());
        result = result * 59 + (this.databaseRole == null ? 43 : this.databaseRole.hashCode());
        result = result * 59 + (this.databaseConnectionType == null ? 43 : this.databaseConnectionType.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.databaseWalletDetails == null ? 43 : this.databaseWalletDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="databaseAuthenticationDetails")
        private BasicAuthenticationDetails databaseAuthenticationDetails;
        @JsonProperty(value="databaseRole")
        private String databaseRole;
        @JsonProperty(value="databaseConnectionType")
        private DatabaseConnectionType databaseConnectionType;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="databaseWalletDetails")
        private DatabaseWalletDetails databaseWalletDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder databaseAuthenticationDetails(BasicAuthenticationDetails databaseAuthenticationDetails) {
            this.databaseAuthenticationDetails = databaseAuthenticationDetails;
            this.__explicitlySet__.add("databaseAuthenticationDetails");
            return this;
        }

        public Builder databaseRole(String databaseRole) {
            this.databaseRole = databaseRole;
            this.__explicitlySet__.add("databaseRole");
            return this;
        }

        public Builder databaseConnectionType(DatabaseConnectionType databaseConnectionType) {
            this.databaseConnectionType = databaseConnectionType;
            this.__explicitlySet__.add("databaseConnectionType");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder databaseWalletDetails(DatabaseWalletDetails databaseWalletDetails) {
            this.databaseWalletDetails = databaseWalletDetails;
            this.__explicitlySet__.add("databaseWalletDetails");
            return this;
        }

        public SqlMonitorConfiguration build() {
            SqlMonitorConfiguration model = new SqlMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.databaseType, this.query, this.databaseAuthenticationDetails, this.databaseRole, this.databaseConnectionType, this.connectionString, this.databaseWalletDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("databaseAuthenticationDetails")) {
                this.databaseAuthenticationDetails(model.getDatabaseAuthenticationDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseRole")) {
                this.databaseRole(model.getDatabaseRole());
            }
            if (model.wasPropertyExplicitlySet("databaseConnectionType")) {
                this.databaseConnectionType(model.getDatabaseConnectionType());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("databaseWalletDetails")) {
                this.databaseWalletDetails(model.getDatabaseWalletDetails());
            }
            return this;
        }
    }
}

