/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.MonitorTypes;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkerMonitorList
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="monitorType")
    private final MonitorTypes monitorType;
    @JsonProperty(value="isRunNow")
    private final Boolean isRunNow;
    @JsonProperty(value="timeAssigned")
    private final Date timeAssigned;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "monitorType", "isRunNow", "timeAssigned"})
    public WorkerMonitorList(String id, String displayName, MonitorTypes monitorType, Boolean isRunNow, Date timeAssigned) {
        this.id = id;
        this.displayName = displayName;
        this.monitorType = monitorType;
        this.isRunNow = isRunNow;
        this.timeAssigned = timeAssigned;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MonitorTypes getMonitorType() {
        return this.monitorType;
    }

    public Boolean getIsRunNow() {
        return this.isRunNow;
    }

    public Date getTimeAssigned() {
        return this.timeAssigned;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkerMonitorList(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", monitorType=").append(String.valueOf((Object)this.monitorType));
        sb.append(", isRunNow=").append(String.valueOf(this.isRunNow));
        sb.append(", timeAssigned=").append(String.valueOf(this.timeAssigned));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerMonitorList)) {
            return false;
        }
        WorkerMonitorList other = (WorkerMonitorList)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.monitorType, (Object)other.monitorType) && Objects.equals(this.isRunNow, other.isRunNow) && Objects.equals(this.timeAssigned, other.timeAssigned) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.monitorType == null ? 43 : this.monitorType.hashCode());
        result = result * 59 + (this.isRunNow == null ? 43 : this.isRunNow.hashCode());
        result = result * 59 + (this.timeAssigned == null ? 43 : this.timeAssigned.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="monitorType")
        private MonitorTypes monitorType;
        @JsonProperty(value="isRunNow")
        private Boolean isRunNow;
        @JsonProperty(value="timeAssigned")
        private Date timeAssigned;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder monitorType(MonitorTypes monitorType) {
            this.monitorType = monitorType;
            this.__explicitlySet__.add("monitorType");
            return this;
        }

        public Builder isRunNow(Boolean isRunNow) {
            this.isRunNow = isRunNow;
            this.__explicitlySet__.add("isRunNow");
            return this;
        }

        public Builder timeAssigned(Date timeAssigned) {
            this.timeAssigned = timeAssigned;
            this.__explicitlySet__.add("timeAssigned");
            return this;
        }

        public WorkerMonitorList build() {
            WorkerMonitorList model = new WorkerMonitorList(this.id, this.displayName, this.monitorType, this.isRunNow, this.timeAssigned);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkerMonitorList model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("monitorType")) {
                this.monitorType(model.getMonitorType());
            }
            if (model.wasPropertyExplicitlySet("isRunNow")) {
                this.isRunNow(model.getIsRunNow());
            }
            if (model.wasPropertyExplicitlySet("timeAssigned")) {
                this.timeAssigned(model.getTimeAssigned());
            }
            return this;
        }
    }
}

