/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import com.oracle.bmc.apmsynthetics.model.VerifyText;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class BrowserMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="isCertificateValidationEnabled")
    private final Boolean isCertificateValidationEnabled;
    @JsonProperty(value="isDefaultSnapshotEnabled")
    private final Boolean isDefaultSnapshotEnabled;
    @JsonProperty(value="verifyTexts")
    private final List<VerifyText> verifyTexts;
    @JsonProperty(value="verifyResponseCodes")
    private final List<String> verifyResponseCodes;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BrowserMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, Boolean isCertificateValidationEnabled, Boolean isDefaultSnapshotEnabled, List<VerifyText> verifyTexts, List<String> verifyResponseCodes, NetworkConfiguration networkConfiguration) {
        super(isFailureRetried, dnsConfiguration);
        this.isCertificateValidationEnabled = isCertificateValidationEnabled;
        this.isDefaultSnapshotEnabled = isDefaultSnapshotEnabled;
        this.verifyTexts = verifyTexts;
        this.verifyResponseCodes = verifyResponseCodes;
        this.networkConfiguration = networkConfiguration;
    }

    public Boolean getIsCertificateValidationEnabled() {
        return this.isCertificateValidationEnabled;
    }

    public Boolean getIsDefaultSnapshotEnabled() {
        return this.isDefaultSnapshotEnabled;
    }

    public List<VerifyText> getVerifyTexts() {
        return this.verifyTexts;
    }

    public List<String> getVerifyResponseCodes() {
        return this.verifyResponseCodes;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BrowserMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isCertificateValidationEnabled=").append(String.valueOf(this.isCertificateValidationEnabled));
        sb.append(", isDefaultSnapshotEnabled=").append(String.valueOf(this.isDefaultSnapshotEnabled));
        sb.append(", verifyTexts=").append(String.valueOf(this.verifyTexts));
        sb.append(", verifyResponseCodes=").append(String.valueOf(this.verifyResponseCodes));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowserMonitorConfiguration)) {
            return false;
        }
        BrowserMonitorConfiguration other = (BrowserMonitorConfiguration)((Object)o);
        return Objects.equals(this.isCertificateValidationEnabled, other.isCertificateValidationEnabled) && Objects.equals(this.isDefaultSnapshotEnabled, other.isDefaultSnapshotEnabled) && Objects.equals(this.verifyTexts, other.verifyTexts) && Objects.equals(this.verifyResponseCodes, other.verifyResponseCodes) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCertificateValidationEnabled == null ? 43 : this.isCertificateValidationEnabled.hashCode());
        result = result * 59 + (this.isDefaultSnapshotEnabled == null ? 43 : this.isDefaultSnapshotEnabled.hashCode());
        result = result * 59 + (this.verifyTexts == null ? 43 : this.verifyTexts.hashCode());
        result = result * 59 + (this.verifyResponseCodes == null ? 43 : this.verifyResponseCodes.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="isCertificateValidationEnabled")
        private Boolean isCertificateValidationEnabled;
        @JsonProperty(value="isDefaultSnapshotEnabled")
        private Boolean isDefaultSnapshotEnabled;
        @JsonProperty(value="verifyTexts")
        private List<VerifyText> verifyTexts;
        @JsonProperty(value="verifyResponseCodes")
        private List<String> verifyResponseCodes;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder isCertificateValidationEnabled(Boolean isCertificateValidationEnabled) {
            this.isCertificateValidationEnabled = isCertificateValidationEnabled;
            this.__explicitlySet__.add("isCertificateValidationEnabled");
            return this;
        }

        public Builder isDefaultSnapshotEnabled(Boolean isDefaultSnapshotEnabled) {
            this.isDefaultSnapshotEnabled = isDefaultSnapshotEnabled;
            this.__explicitlySet__.add("isDefaultSnapshotEnabled");
            return this;
        }

        public Builder verifyTexts(List<VerifyText> verifyTexts) {
            this.verifyTexts = verifyTexts;
            this.__explicitlySet__.add("verifyTexts");
            return this;
        }

        public Builder verifyResponseCodes(List<String> verifyResponseCodes) {
            this.verifyResponseCodes = verifyResponseCodes;
            this.__explicitlySet__.add("verifyResponseCodes");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public BrowserMonitorConfiguration build() {
            BrowserMonitorConfiguration model = new BrowserMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.isCertificateValidationEnabled, this.isDefaultSnapshotEnabled, this.verifyTexts, this.verifyResponseCodes, this.networkConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BrowserMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("isCertificateValidationEnabled")) {
                this.isCertificateValidationEnabled(model.getIsCertificateValidationEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDefaultSnapshotEnabled")) {
                this.isDefaultSnapshotEnabled(model.getIsDefaultSnapshotEnabled());
            }
            if (model.wasPropertyExplicitlySet("verifyTexts")) {
                this.verifyTexts(model.getVerifyTexts());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseCodes")) {
                this.verifyResponseCodes(model.getVerifyResponseCodes());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            return this;
        }
    }
}

