/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsRecordType;
import com.oracle.bmc.apmsynthetics.model.DnsTransportProtocol;
import com.oracle.bmc.apmsynthetics.model.MonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class DnsServerMonitorConfiguration
extends MonitorConfiguration {
    @JsonProperty(value="recordType")
    private final DnsRecordType recordType;
    @JsonProperty(value="nameServer")
    private final String nameServer;
    @JsonProperty(value="networkConfiguration")
    private final NetworkConfiguration networkConfiguration;
    @JsonProperty(value="protocol")
    private final DnsTransportProtocol protocol;
    @JsonProperty(value="verifyResponseContent")
    private final String verifyResponseContent;
    @JsonProperty(value="isQueryRecursive")
    private final Boolean isQueryRecursive;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DnsServerMonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration, DnsRecordType recordType, String nameServer, NetworkConfiguration networkConfiguration, DnsTransportProtocol protocol, String verifyResponseContent, Boolean isQueryRecursive) {
        super(isFailureRetried, dnsConfiguration);
        this.recordType = recordType;
        this.nameServer = nameServer;
        this.networkConfiguration = networkConfiguration;
        this.protocol = protocol;
        this.verifyResponseContent = verifyResponseContent;
        this.isQueryRecursive = isQueryRecursive;
    }

    public DnsRecordType getRecordType() {
        return this.recordType;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public DnsTransportProtocol getProtocol() {
        return this.protocol;
    }

    public String getVerifyResponseContent() {
        return this.verifyResponseContent;
    }

    public Boolean getIsQueryRecursive() {
        return this.isQueryRecursive;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DnsServerMonitorConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", recordType=").append(String.valueOf((Object)this.recordType));
        sb.append(", nameServer=").append(String.valueOf(this.nameServer));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", verifyResponseContent=").append(String.valueOf(this.verifyResponseContent));
        sb.append(", isQueryRecursive=").append(String.valueOf(this.isQueryRecursive));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnsServerMonitorConfiguration)) {
            return false;
        }
        DnsServerMonitorConfiguration other = (DnsServerMonitorConfiguration)((Object)o);
        return Objects.equals((Object)this.recordType, (Object)other.recordType) && Objects.equals(this.nameServer, other.nameServer) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.verifyResponseContent, other.verifyResponseContent) && Objects.equals(this.isQueryRecursive, other.isQueryRecursive) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recordType == null ? 43 : this.recordType.hashCode());
        result = result * 59 + (this.nameServer == null ? 43 : this.nameServer.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.verifyResponseContent == null ? 43 : this.verifyResponseContent.hashCode());
        result = result * 59 + (this.isQueryRecursive == null ? 43 : this.isQueryRecursive.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFailureRetried")
        private Boolean isFailureRetried;
        @JsonProperty(value="dnsConfiguration")
        private DnsConfiguration dnsConfiguration;
        @JsonProperty(value="recordType")
        private DnsRecordType recordType;
        @JsonProperty(value="nameServer")
        private String nameServer;
        @JsonProperty(value="networkConfiguration")
        private NetworkConfiguration networkConfiguration;
        @JsonProperty(value="protocol")
        private DnsTransportProtocol protocol;
        @JsonProperty(value="verifyResponseContent")
        private String verifyResponseContent;
        @JsonProperty(value="isQueryRecursive")
        private Boolean isQueryRecursive;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFailureRetried(Boolean isFailureRetried) {
            this.isFailureRetried = isFailureRetried;
            this.__explicitlySet__.add("isFailureRetried");
            return this;
        }

        public Builder dnsConfiguration(DnsConfiguration dnsConfiguration) {
            this.dnsConfiguration = dnsConfiguration;
            this.__explicitlySet__.add("dnsConfiguration");
            return this;
        }

        public Builder recordType(DnsRecordType recordType) {
            this.recordType = recordType;
            this.__explicitlySet__.add("recordType");
            return this;
        }

        public Builder nameServer(String nameServer) {
            this.nameServer = nameServer;
            this.__explicitlySet__.add("nameServer");
            return this;
        }

        public Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public Builder protocol(DnsTransportProtocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder verifyResponseContent(String verifyResponseContent) {
            this.verifyResponseContent = verifyResponseContent;
            this.__explicitlySet__.add("verifyResponseContent");
            return this;
        }

        public Builder isQueryRecursive(Boolean isQueryRecursive) {
            this.isQueryRecursive = isQueryRecursive;
            this.__explicitlySet__.add("isQueryRecursive");
            return this;
        }

        public DnsServerMonitorConfiguration build() {
            DnsServerMonitorConfiguration model = new DnsServerMonitorConfiguration(this.isFailureRetried, this.dnsConfiguration, this.recordType, this.nameServer, this.networkConfiguration, this.protocol, this.verifyResponseContent, this.isQueryRecursive);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DnsServerMonitorConfiguration model) {
            if (model.wasPropertyExplicitlySet("isFailureRetried")) {
                this.isFailureRetried(model.getIsFailureRetried());
            }
            if (model.wasPropertyExplicitlySet("dnsConfiguration")) {
                this.dnsConfiguration(model.getDnsConfiguration());
            }
            if (model.wasPropertyExplicitlySet("recordType")) {
                this.recordType(model.getRecordType());
            }
            if (model.wasPropertyExplicitlySet("nameServer")) {
                this.nameServer(model.getNameServer());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("verifyResponseContent")) {
                this.verifyResponseContent(model.getVerifyResponseContent());
            }
            if (model.wasPropertyExplicitlySet("isQueryRecursive")) {
                this.isQueryRecursive(model.getIsQueryRecursive());
            }
            return this;
        }
    }
}

