/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Link
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="repeatCount")
    private final Integer repeatCount;
    @JsonProperty(value="forwardingLoss")
    private final Double forwardingLoss;
    @JsonProperty(value="delayInMilliseconds")
    private final Double delayInMilliseconds;
    @JsonProperty(value="minDelayInMilliseconds")
    private final Double minDelayInMilliseconds;
    @JsonProperty(value="maxDelayInMilliseconds")
    private final Double maxDelayInMilliseconds;
    @JsonProperty(value="paths")
    private final List<String> paths;

    @Deprecated
    @ConstructorProperties(value={"id", "source", "destination", "repeatCount", "forwardingLoss", "delayInMilliseconds", "minDelayInMilliseconds", "maxDelayInMilliseconds", "paths"})
    public Link(String id, String source, String destination, Integer repeatCount, Double forwardingLoss, Double delayInMilliseconds, Double minDelayInMilliseconds, Double maxDelayInMilliseconds, List<String> paths) {
        this.id = id;
        this.source = source;
        this.destination = destination;
        this.repeatCount = repeatCount;
        this.forwardingLoss = forwardingLoss;
        this.delayInMilliseconds = delayInMilliseconds;
        this.minDelayInMilliseconds = minDelayInMilliseconds;
        this.maxDelayInMilliseconds = maxDelayInMilliseconds;
        this.paths = paths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public Double getForwardingLoss() {
        return this.forwardingLoss;
    }

    public Double getDelayInMilliseconds() {
        return this.delayInMilliseconds;
    }

    public Double getMinDelayInMilliseconds() {
        return this.minDelayInMilliseconds;
    }

    public Double getMaxDelayInMilliseconds() {
        return this.maxDelayInMilliseconds;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Link(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", destination=").append(String.valueOf(this.destination));
        sb.append(", repeatCount=").append(String.valueOf(this.repeatCount));
        sb.append(", forwardingLoss=").append(String.valueOf(this.forwardingLoss));
        sb.append(", delayInMilliseconds=").append(String.valueOf(this.delayInMilliseconds));
        sb.append(", minDelayInMilliseconds=").append(String.valueOf(this.minDelayInMilliseconds));
        sb.append(", maxDelayInMilliseconds=").append(String.valueOf(this.maxDelayInMilliseconds));
        sb.append(", paths=").append(String.valueOf(this.paths));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source) && Objects.equals(this.destination, other.destination) && Objects.equals(this.repeatCount, other.repeatCount) && Objects.equals(this.forwardingLoss, other.forwardingLoss) && Objects.equals(this.delayInMilliseconds, other.delayInMilliseconds) && Objects.equals(this.minDelayInMilliseconds, other.minDelayInMilliseconds) && Objects.equals(this.maxDelayInMilliseconds, other.maxDelayInMilliseconds) && Objects.equals(this.paths, other.paths) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + (this.repeatCount == null ? 43 : this.repeatCount.hashCode());
        result = result * 59 + (this.forwardingLoss == null ? 43 : this.forwardingLoss.hashCode());
        result = result * 59 + (this.delayInMilliseconds == null ? 43 : this.delayInMilliseconds.hashCode());
        result = result * 59 + (this.minDelayInMilliseconds == null ? 43 : this.minDelayInMilliseconds.hashCode());
        result = result * 59 + (this.maxDelayInMilliseconds == null ? 43 : this.maxDelayInMilliseconds.hashCode());
        result = result * 59 + (this.paths == null ? 43 : this.paths.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="repeatCount")
        private Integer repeatCount;
        @JsonProperty(value="forwardingLoss")
        private Double forwardingLoss;
        @JsonProperty(value="delayInMilliseconds")
        private Double delayInMilliseconds;
        @JsonProperty(value="minDelayInMilliseconds")
        private Double minDelayInMilliseconds;
        @JsonProperty(value="maxDelayInMilliseconds")
        private Double maxDelayInMilliseconds;
        @JsonProperty(value="paths")
        private List<String> paths;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder repeatCount(Integer repeatCount) {
            this.repeatCount = repeatCount;
            this.__explicitlySet__.add("repeatCount");
            return this;
        }

        public Builder forwardingLoss(Double forwardingLoss) {
            this.forwardingLoss = forwardingLoss;
            this.__explicitlySet__.add("forwardingLoss");
            return this;
        }

        public Builder delayInMilliseconds(Double delayInMilliseconds) {
            this.delayInMilliseconds = delayInMilliseconds;
            this.__explicitlySet__.add("delayInMilliseconds");
            return this;
        }

        public Builder minDelayInMilliseconds(Double minDelayInMilliseconds) {
            this.minDelayInMilliseconds = minDelayInMilliseconds;
            this.__explicitlySet__.add("minDelayInMilliseconds");
            return this;
        }

        public Builder maxDelayInMilliseconds(Double maxDelayInMilliseconds) {
            this.maxDelayInMilliseconds = maxDelayInMilliseconds;
            this.__explicitlySet__.add("maxDelayInMilliseconds");
            return this;
        }

        public Builder paths(List<String> paths) {
            this.paths = paths;
            this.__explicitlySet__.add("paths");
            return this;
        }

        public Link build() {
            Link model = new Link(this.id, this.source, this.destination, this.repeatCount, this.forwardingLoss, this.delayInMilliseconds, this.minDelayInMilliseconds, this.maxDelayInMilliseconds, this.paths);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Link model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            if (model.wasPropertyExplicitlySet("repeatCount")) {
                this.repeatCount(model.getRepeatCount());
            }
            if (model.wasPropertyExplicitlySet("forwardingLoss")) {
                this.forwardingLoss(model.getForwardingLoss());
            }
            if (model.wasPropertyExplicitlySet("delayInMilliseconds")) {
                this.delayInMilliseconds(model.getDelayInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("minDelayInMilliseconds")) {
                this.minDelayInMilliseconds(model.getMinDelayInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("maxDelayInMilliseconds")) {
                this.maxDelayInMilliseconds(model.getMaxDelayInMilliseconds());
            }
            if (model.wasPropertyExplicitlySet("paths")) {
                this.paths(model.getPaths());
            }
            return this;
        }
    }
}

