/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.apmsynthetics.model.BrowserMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsSecMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsServerMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.DnsTraceMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.FtpMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.NetworkMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.RestMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.ScriptedBrowserMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.ScriptedRestMonitorConfiguration;
import com.oracle.bmc.apmsynthetics.model.SqlMonitorConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType", defaultImpl=MonitorConfiguration.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FtpMonitorConfiguration.class, name="FTP_CONFIG"), @JsonSubTypes.Type(value=DnsSecMonitorConfiguration.class, name="DNSSEC_CONFIG"), @JsonSubTypes.Type(value=DnsTraceMonitorConfiguration.class, name="DNS_TRACE_CONFIG"), @JsonSubTypes.Type(value=SqlMonitorConfiguration.class, name="SQL_CONFIG"), @JsonSubTypes.Type(value=ScriptedRestMonitorConfiguration.class, name="SCRIPTED_REST_CONFIG"), @JsonSubTypes.Type(value=DnsServerMonitorConfiguration.class, name="DNS_SERVER_CONFIG"), @JsonSubTypes.Type(value=ScriptedBrowserMonitorConfiguration.class, name="SCRIPTED_BROWSER_CONFIG"), @JsonSubTypes.Type(value=RestMonitorConfiguration.class, name="REST_CONFIG"), @JsonSubTypes.Type(value=BrowserMonitorConfiguration.class, name="BROWSER_CONFIG"), @JsonSubTypes.Type(value=NetworkMonitorConfiguration.class, name="NETWORK_CONFIG")})
@JsonFilter(value="explicitlySetFilter")
public class MonitorConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isFailureRetried")
    private final Boolean isFailureRetried;
    @JsonProperty(value="dnsConfiguration")
    private final DnsConfiguration dnsConfiguration;

    @Deprecated
    @ConstructorProperties(value={"isFailureRetried", "dnsConfiguration"})
    protected MonitorConfiguration(Boolean isFailureRetried, DnsConfiguration dnsConfiguration) {
        this.isFailureRetried = isFailureRetried;
        this.dnsConfiguration = dnsConfiguration;
    }

    public Boolean getIsFailureRetried() {
        return this.isFailureRetried;
    }

    public DnsConfiguration getDnsConfiguration() {
        return this.dnsConfiguration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitorConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("isFailureRetried=").append(String.valueOf(this.isFailureRetried));
        sb.append(", dnsConfiguration=").append(String.valueOf((Object)this.dnsConfiguration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitorConfiguration)) {
            return false;
        }
        MonitorConfiguration other = (MonitorConfiguration)((Object)o);
        return Objects.equals(this.isFailureRetried, other.isFailureRetried) && Objects.equals((Object)this.dnsConfiguration, (Object)other.dnsConfiguration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFailureRetried == null ? 43 : this.isFailureRetried.hashCode());
        result = result * 59 + (this.dnsConfiguration == null ? 43 : this.dnsConfiguration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConfigType implements BmcEnum
    {
        BrowserConfig("BROWSER_CONFIG"),
        ScriptedBrowserConfig("SCRIPTED_BROWSER_CONFIG"),
        RestConfig("REST_CONFIG"),
        ScriptedRestConfig("SCRIPTED_REST_CONFIG"),
        NetworkConfig("NETWORK_CONFIG"),
        DnsServerConfig("DNS_SERVER_CONFIG"),
        DnsTraceConfig("DNS_TRACE_CONFIG"),
        DnssecConfig("DNSSEC_CONFIG"),
        FtpConfig("FTP_CONFIG"),
        SqlConfig("SQL_CONFIG"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConfigType> map;

        private ConfigType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConfigType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConfigType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConfigType.class);
            map = new HashMap<String, ConfigType>();
            for (ConfigType v : ConfigType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

