/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmsynthetics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apmsynthetics.model.MonitorResultData;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MonitorResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resultType")
    private final String resultType;
    @JsonProperty(value="resultContentType")
    private final String resultContentType;
    @JsonProperty(value="resultDataSet")
    private final List<MonitorResultData> resultDataSet;
    @JsonProperty(value="monitorId")
    private final String monitorId;
    @JsonProperty(value="vantagePoint")
    private final String vantagePoint;
    @JsonProperty(value="executionTime")
    private final String executionTime;

    @Deprecated
    @ConstructorProperties(value={"resultType", "resultContentType", "resultDataSet", "monitorId", "vantagePoint", "executionTime"})
    public MonitorResult(String resultType, String resultContentType, List<MonitorResultData> resultDataSet, String monitorId, String vantagePoint, String executionTime) {
        this.resultType = resultType;
        this.resultContentType = resultContentType;
        this.resultDataSet = resultDataSet;
        this.monitorId = monitorId;
        this.vantagePoint = vantagePoint;
        this.executionTime = executionTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getResultContentType() {
        return this.resultContentType;
    }

    public List<MonitorResultData> getResultDataSet() {
        return this.resultDataSet;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getVantagePoint() {
        return this.vantagePoint;
    }

    public String getExecutionTime() {
        return this.executionTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MonitorResult(");
        sb.append("super=").append(super.toString());
        sb.append("resultType=").append(String.valueOf(this.resultType));
        sb.append(", resultContentType=").append(String.valueOf(this.resultContentType));
        sb.append(", resultDataSet=").append(String.valueOf(this.resultDataSet));
        sb.append(", monitorId=").append(String.valueOf(this.monitorId));
        sb.append(", vantagePoint=").append(String.valueOf(this.vantagePoint));
        sb.append(", executionTime=").append(String.valueOf(this.executionTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MonitorResult)) {
            return false;
        }
        MonitorResult other = (MonitorResult)((Object)o);
        return Objects.equals(this.resultType, other.resultType) && Objects.equals(this.resultContentType, other.resultContentType) && Objects.equals(this.resultDataSet, other.resultDataSet) && Objects.equals(this.monitorId, other.monitorId) && Objects.equals(this.vantagePoint, other.vantagePoint) && Objects.equals(this.executionTime, other.executionTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resultType == null ? 43 : this.resultType.hashCode());
        result = result * 59 + (this.resultContentType == null ? 43 : this.resultContentType.hashCode());
        result = result * 59 + (this.resultDataSet == null ? 43 : this.resultDataSet.hashCode());
        result = result * 59 + (this.monitorId == null ? 43 : this.monitorId.hashCode());
        result = result * 59 + (this.vantagePoint == null ? 43 : this.vantagePoint.hashCode());
        result = result * 59 + (this.executionTime == null ? 43 : this.executionTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resultType")
        private String resultType;
        @JsonProperty(value="resultContentType")
        private String resultContentType;
        @JsonProperty(value="resultDataSet")
        private List<MonitorResultData> resultDataSet;
        @JsonProperty(value="monitorId")
        private String monitorId;
        @JsonProperty(value="vantagePoint")
        private String vantagePoint;
        @JsonProperty(value="executionTime")
        private String executionTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resultType(String resultType) {
            this.resultType = resultType;
            this.__explicitlySet__.add("resultType");
            return this;
        }

        public Builder resultContentType(String resultContentType) {
            this.resultContentType = resultContentType;
            this.__explicitlySet__.add("resultContentType");
            return this;
        }

        public Builder resultDataSet(List<MonitorResultData> resultDataSet) {
            this.resultDataSet = resultDataSet;
            this.__explicitlySet__.add("resultDataSet");
            return this;
        }

        public Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            this.__explicitlySet__.add("monitorId");
            return this;
        }

        public Builder vantagePoint(String vantagePoint) {
            this.vantagePoint = vantagePoint;
            this.__explicitlySet__.add("vantagePoint");
            return this;
        }

        public Builder executionTime(String executionTime) {
            this.executionTime = executionTime;
            this.__explicitlySet__.add("executionTime");
            return this;
        }

        public MonitorResult build() {
            MonitorResult model = new MonitorResult(this.resultType, this.resultContentType, this.resultDataSet, this.monitorId, this.vantagePoint, this.executionTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MonitorResult model) {
            if (model.wasPropertyExplicitlySet("resultType")) {
                this.resultType(model.getResultType());
            }
            if (model.wasPropertyExplicitlySet("resultContentType")) {
                this.resultContentType(model.getResultContentType());
            }
            if (model.wasPropertyExplicitlySet("resultDataSet")) {
                this.resultDataSet(model.getResultDataSet());
            }
            if (model.wasPropertyExplicitlySet("monitorId")) {
                this.monitorId(model.getMonitorId());
            }
            if (model.wasPropertyExplicitlySet("vantagePoint")) {
                this.vantagePoint(model.getVantagePoint());
            }
            if (model.wasPropertyExplicitlySet("executionTime")) {
                this.executionTime(model.getExecutionTime());
            }
            return this;
        }
    }
}

