/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmtraces.Attributes;
import com.oracle.bmc.apmtraces.model.AutoActivateStatus;
import com.oracle.bmc.apmtraces.model.AutoActivateToggleStatus;
import com.oracle.bmc.apmtraces.model.BulkActivationStatus;
import com.oracle.bmc.apmtraces.model.BulkDeActivationStatus;
import com.oracle.bmc.apmtraces.model.BulkPinStatus;
import com.oracle.bmc.apmtraces.model.BulkUnpinStatus;
import com.oracle.bmc.apmtraces.model.BulkUpdateAttributeStatus;
import com.oracle.bmc.apmtraces.model.BulkUpdateNotesStatus;
import com.oracle.bmc.apmtraces.requests.BulkActivateAttributeRequest;
import com.oracle.bmc.apmtraces.requests.BulkDeActivateAttributeRequest;
import com.oracle.bmc.apmtraces.requests.BulkPinAttributeRequest;
import com.oracle.bmc.apmtraces.requests.BulkUnpinAttributeRequest;
import com.oracle.bmc.apmtraces.requests.BulkUpdateAttributeNotesRequest;
import com.oracle.bmc.apmtraces.requests.BulkUpdateAttributeRequest;
import com.oracle.bmc.apmtraces.requests.GetStatusAutoActivateRequest;
import com.oracle.bmc.apmtraces.requests.PutToggleAutoActivateRequest;
import com.oracle.bmc.apmtraces.responses.BulkActivateAttributeResponse;
import com.oracle.bmc.apmtraces.responses.BulkDeActivateAttributeResponse;
import com.oracle.bmc.apmtraces.responses.BulkPinAttributeResponse;
import com.oracle.bmc.apmtraces.responses.BulkUnpinAttributeResponse;
import com.oracle.bmc.apmtraces.responses.BulkUpdateAttributeNotesResponse;
import com.oracle.bmc.apmtraces.responses.BulkUpdateAttributeResponse;
import com.oracle.bmc.apmtraces.responses.GetStatusAutoActivateResponse;
import com.oracle.bmc.apmtraces.responses.PutToggleAutoActivateResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesClient
extends BaseSyncClient
implements Attributes {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ATTRIBUTES").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-trace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AttributesClient.class);

    AttributesClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BulkActivateAttributeResponse bulkActivateAttribute(BulkActivateAttributeRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkActivateAttributeDetails(), "bulkActivateAttributeDetails is required");
        return (BulkActivateAttributeResponse)this.clientCall(request, BulkActivateAttributeResponse::builder).logger(LOG, "bulkActivateAttribute").serviceDetails("Attributes", "BulkActivateAttribute", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkActivationStatus/BulkActivateAttribute").method(Method.POST).requestBuilder(BulkActivateAttributeRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("activateAttributes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkActivationStatus.class, BulkActivateAttributeResponse.Builder::bulkActivationStatus).handleResponseHeaderString("opc-request-id", BulkActivateAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkDeActivateAttributeResponse bulkDeActivateAttribute(BulkDeActivateAttributeRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkDeActivateAttributeDetails(), "bulkDeActivateAttributeDetails is required");
        return (BulkDeActivateAttributeResponse)this.clientCall(request, BulkDeActivateAttributeResponse::builder).logger(LOG, "bulkDeActivateAttribute").serviceDetails("Attributes", "BulkDeActivateAttribute", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkDeActivationStatus/BulkDeActivateAttribute").method(Method.POST).requestBuilder(BulkDeActivateAttributeRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("deActivateAttributes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkDeActivationStatus.class, BulkDeActivateAttributeResponse.Builder::bulkDeActivationStatus).handleResponseHeaderString("opc-request-id", BulkDeActivateAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkPinAttributeResponse bulkPinAttribute(BulkPinAttributeRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkPinAttributeDetails(), "bulkPinAttributeDetails is required");
        return (BulkPinAttributeResponse)this.clientCall(request, BulkPinAttributeResponse::builder).logger(LOG, "bulkPinAttribute").serviceDetails("Attributes", "BulkPinAttribute", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkPinStatus/BulkPinAttribute").method(Method.POST).requestBuilder(BulkPinAttributeRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("pinAttributes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkPinStatus.class, BulkPinAttributeResponse.Builder::bulkPinStatus).handleResponseHeaderString("opc-request-id", BulkPinAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkUnpinAttributeResponse bulkUnpinAttribute(BulkUnpinAttributeRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkUnpinAttributeDetails(), "bulkUnpinAttributeDetails is required");
        return (BulkUnpinAttributeResponse)this.clientCall(request, BulkUnpinAttributeResponse::builder).logger(LOG, "bulkUnpinAttribute").serviceDetails("Attributes", "BulkUnpinAttribute", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkUnpinStatus/BulkUnpinAttribute").method(Method.POST).requestBuilder(BulkUnpinAttributeRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("unPinAttributes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkUnpinStatus.class, BulkUnpinAttributeResponse.Builder::bulkUnpinStatus).handleResponseHeaderString("opc-request-id", BulkUnpinAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkUpdateAttributeResponse bulkUpdateAttribute(BulkUpdateAttributeRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkUpdateAttributeDetails(), "bulkUpdateAttributeDetails is required");
        return (BulkUpdateAttributeResponse)this.clientCall(request, BulkUpdateAttributeResponse::builder).logger(LOG, "bulkUpdateAttribute").serviceDetails("Attributes", "BulkUpdateAttribute", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkUpdateAttributeStatus/BulkUpdateAttribute").method(Method.POST).requestBuilder(BulkUpdateAttributeRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("updateAttributes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkUpdateAttributeStatus.class, BulkUpdateAttributeResponse.Builder::bulkUpdateAttributeStatus).handleResponseHeaderString("opc-request-id", BulkUpdateAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BulkUpdateAttributeNotesResponse bulkUpdateAttributeNotes(BulkUpdateAttributeNotesRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getBulkUpdateAttributeNotesDetails(), "bulkUpdateAttributeNotesDetails is required");
        return (BulkUpdateAttributeNotesResponse)this.clientCall(request, BulkUpdateAttributeNotesResponse::builder).logger(LOG, "bulkUpdateAttributeNotes").serviceDetails("Attributes", "BulkUpdateAttributeNotes", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/BulkUpdateNotesStatus/BulkUpdateAttributeNotes").method(Method.POST).requestBuilder(BulkUpdateAttributeNotesRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("updateNotes").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BulkUpdateNotesStatus.class, BulkUpdateAttributeNotesResponse.Builder::bulkUpdateNotesStatus).handleResponseHeaderString("opc-request-id", BulkUpdateAttributeNotesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetStatusAutoActivateResponse getStatusAutoActivate(GetStatusAutoActivateRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getDataKeyType(), "dataKeyType is required");
        return (GetStatusAutoActivateResponse)this.clientCall(request, GetStatusAutoActivateResponse::builder).logger(LOG, "getStatusAutoActivate").serviceDetails("Attributes", "GetStatusAutoActivate", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/AutoActivateStatus/GetStatusAutoActivate").method(Method.GET).requestBuilder(GetStatusAutoActivateRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("autoActivateStatus").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendEnumQueryParam("dataKeyType", (BmcEnum)request.getDataKeyType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoActivateStatus.class, GetStatusAutoActivateResponse.Builder::autoActivateStatus).handleResponseHeaderString("opc-request-id", GetStatusAutoActivateResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PutToggleAutoActivateResponse putToggleAutoActivate(PutToggleAutoActivateRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getIsAutoActivateOn(), "isAutoActivateOn is required");
        Objects.requireNonNull(request.getDataKeyType(), "dataKeyType is required");
        return (PutToggleAutoActivateResponse)this.clientCall(request, PutToggleAutoActivateResponse::builder).logger(LOG, "putToggleAutoActivate").serviceDetails("Attributes", "PutToggleAutoActivate", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/AutoActivateToggleStatus/PutToggleAutoActivate").method(Method.POST).requestBuilder(PutToggleAutoActivateRequest::builder).basePath("/20200630").appendPathParam("attributes").appendPathParam("actions").appendPathParam("autoActivate").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("isAutoActivateOn", (Object)request.getIsAutoActivateOn()).appendEnumQueryParam("dataKeyType", (BmcEnum)request.getDataKeyType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AutoActivateToggleStatus.class, PutToggleAutoActivateResponse.Builder::autoActivateToggleStatus).handleResponseHeaderString("opc-request-id", PutToggleAutoActivateResponse.Builder::opcRequestId).callSync();
    }

    @Deprecated
    public AttributesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AttributesClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AttributesClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AttributesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AttributesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AttributesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AttributesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AttributesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AttributesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AttributesClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "apmtraces";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apmtraces");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AttributesClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AttributesClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

