/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmtraces.Query;
import com.oracle.bmc.apmtraces.QueryPaginators;
import com.oracle.bmc.apmtraces.model.QueryResultResponse;
import com.oracle.bmc.apmtraces.model.QuickPickSummary;
import com.oracle.bmc.apmtraces.requests.ListQuickPicksRequest;
import com.oracle.bmc.apmtraces.requests.QueryRequest;
import com.oracle.bmc.apmtraces.responses.ListQuickPicksResponse;
import com.oracle.bmc.apmtraces.responses.QueryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClient
extends BaseSyncClient
implements Query {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-trace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QueryClient.class);
    private final QueryPaginators paginators = new QueryPaginators(this);

    QueryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListQuickPicksResponse listQuickPicks(ListQuickPicksRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        return (ListQuickPicksResponse)this.clientCall(request, ListQuickPicksResponse::builder).logger(LOG, "listQuickPicks").serviceDetails("Query", "ListQuickPicks", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/QuickPickSummary/ListQuickPicks").method(Method.GET).requestBuilder(ListQuickPicksRequest::builder).basePath("/20200630").appendPathParam("queries").appendPathParam("quickPicks").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(QuickPickSummary.class, ListQuickPicksResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListQuickPicksResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", ListQuickPicksResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-next-page", ListQuickPicksResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public QueryResponse query(QueryRequest request) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Objects.requireNonNull(request.getTimeSpanStartedGreaterThanOrEqualTo(), "timeSpanStartedGreaterThanOrEqualTo is required");
        Objects.requireNonNull(request.getTimeSpanStartedLessThan(), "timeSpanStartedLessThan is required");
        Objects.requireNonNull(request.getQueryDetails(), "queryDetails is required");
        return (QueryResponse)this.clientCall(request, QueryResponse::builder).logger(LOG, "query").serviceDetails("Query", "Query", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/QueryResultResponse/Query").method(Method.POST).requestBuilder(QueryRequest::builder).basePath("/20200630").appendPathParam("queries").appendPathParam("actions").appendPathParam("runQuery").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("timeSpanStartedGreaterThanOrEqualTo", (Object)request.getTimeSpanStartedGreaterThanOrEqualTo()).appendQueryParam("timeSpanStartedLessThan", (Object)request.getTimeSpanStartedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(QueryResultResponse.class, QueryResponse.Builder::queryResultResponse).handleResponseHeaderString("opc-request-id", QueryResponse.Builder::opcRequestId).handleResponseHeaderInteger("opc-total-items", QueryResponse.Builder::opcTotalItems).handleResponseHeaderString("opc-next-page", QueryResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public QueryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public QueryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QueryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QueryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QueryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QueryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QueryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QueryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public QueryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QueryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QueryClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "apmtraces";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apmtraces");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public QueryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QueryClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

