/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apmtraces.TraceAsync;
import com.oracle.bmc.apmtraces.model.AggregatedSnapshot;
import com.oracle.bmc.apmtraces.model.Span;
import com.oracle.bmc.apmtraces.model.Trace;
import com.oracle.bmc.apmtraces.model.TraceSnapshot;
import com.oracle.bmc.apmtraces.requests.GetAggregatedSnapshotRequest;
import com.oracle.bmc.apmtraces.requests.GetSpanRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceRequest;
import com.oracle.bmc.apmtraces.requests.GetTraceSnapshotRequest;
import com.oracle.bmc.apmtraces.responses.GetAggregatedSnapshotResponse;
import com.oracle.bmc.apmtraces.responses.GetSpanResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceResponse;
import com.oracle.bmc.apmtraces.responses.GetTraceSnapshotResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceAsyncClient
extends BaseAsyncClient
implements TraceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRACE").serviceEndpointPrefix("").serviceEndpointTemplate("https://apm-trace.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(TraceAsyncClient.class);

    TraceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetAggregatedSnapshotResponse> getAggregatedSnapshot(GetAggregatedSnapshotRequest request, AsyncHandler<GetAggregatedSnapshotRequest, GetAggregatedSnapshotResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAggregatedSnapshotResponse::builder).logger(LOG, "getAggregatedSnapshot").serviceDetails("Trace", "GetAggregatedSnapshot", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/AggregatedSnapshot/GetAggregatedSnapshot").method(Method.GET).requestBuilder(GetAggregatedSnapshotRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendPathParam("aggregatedSnapshotData").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("serviceName", (Object)request.getServiceName()).appendQueryParam("serverName", (Object)request.getServerName()).appendQueryParam("spanKey", (Object)request.getSpanKey()).appendQueryParam("spanName", (Object)request.getSpanName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AggregatedSnapshot.class, GetAggregatedSnapshotResponse.Builder::aggregatedSnapshot).handleResponseHeaderString("opc-request-id", GetAggregatedSnapshotResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSpanResponse> getSpan(GetSpanRequest request, AsyncHandler<GetSpanRequest, GetSpanResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getSpanKey(), (String)"spanKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSpanResponse::builder).logger(LOG, "getSpan").serviceDetails("Trace", "GetSpan", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/Span/GetSpan").method(Method.GET).requestBuilder(GetSpanRequest::builder).basePath("/20200630").appendPathParam("spans").appendPathParam(request.getTraceKey()).appendPathParam(request.getSpanKey()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("timeSpanStartedGreaterThanOrEqualTo", (Object)request.getTimeSpanStartedGreaterThanOrEqualTo()).appendQueryParam("timeSpanStartedLessThan", (Object)request.getTimeSpanStartedLessThan()).appendEnumQueryParam("spanNamespace", (BmcEnum)request.getSpanNamespace()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Span.class, GetSpanResponse.Builder::span).handleResponseHeaderString("opc-request-id", GetSpanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTraceResponse> getTrace(GetTraceRequest request, AsyncHandler<GetTraceRequest, GetTraceResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTraceResponse::builder).logger(LOG, "getTrace").serviceDetails("Trace", "GetTrace", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/Trace/GetTrace").method(Method.GET).requestBuilder(GetTraceRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("timeTraceStartedGreaterThanOrEqualTo", (Object)request.getTimeTraceStartedGreaterThanOrEqualTo()).appendQueryParam("timeTraceStartedLessThan", (Object)request.getTimeTraceStartedLessThan()).appendEnumQueryParam("traceNamespace", (BmcEnum)request.getTraceNamespace()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Trace.class, GetTraceResponse.Builder::trace).handleResponseHeaderString("opc-request-id", GetTraceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTraceSnapshotResponse> getTraceSnapshot(GetTraceSnapshotRequest request, AsyncHandler<GetTraceSnapshotRequest, GetTraceSnapshotResponse> handler) {
        Objects.requireNonNull(request.getApmDomainId(), "apmDomainId is required");
        Validate.notBlank((String)request.getTraceKey(), (String)"traceKey must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTraceSnapshotResponse::builder).logger(LOG, "getTraceSnapshot").serviceDetails("Trace", "GetTraceSnapshot", "https://docs.oracle.com/iaas/api/#/en/apm-trace-explorer/20200630/TraceSnapshot/GetTraceSnapshot").method(Method.GET).requestBuilder(GetTraceSnapshotRequest::builder).basePath("/20200630").appendPathParam("traces").appendPathParam(request.getTraceKey()).appendPathParam("snapshotData").appendQueryParam("apmDomainId", (Object)request.getApmDomainId()).appendQueryParam("isSummarized", (Object)request.getIsSummarized()).appendQueryParam("threadId", (Object)request.getThreadId()).appendQueryParam("snapshotTime", (Object)request.getSnapshotTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TraceSnapshot.class, GetTraceSnapshotResponse.Builder::traceSnapshot).handleResponseHeaderString("opc-request-id", GetTraceSnapshotResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public TraceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)TraceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(TraceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)TraceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)TraceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)TraceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)TraceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public TraceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)TraceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TraceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "apmtraces";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apmtraces");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TraceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new TraceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

