/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AttributePinResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attributeName")
    private final String attributeName;
    @JsonProperty(value="notes")
    private final String notes;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="attributeNameSpace")
    private final AttributeNameSpace attributeNameSpace;
    @JsonProperty(value="attributeStatus")
    private final AttributeStatus attributeStatus;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"attributeName", "notes", "operationType", "attributeNameSpace", "attributeStatus", "timeUpdated"})
    public AttributePinResponse(String attributeName, String notes, OperationType operationType, AttributeNameSpace attributeNameSpace, AttributeStatus attributeStatus, Date timeUpdated) {
        this.attributeName = attributeName;
        this.notes = notes;
        this.operationType = operationType;
        this.attributeNameSpace = attributeNameSpace;
        this.attributeStatus = attributeStatus;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getNotes() {
        return this.notes;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public AttributeNameSpace getAttributeNameSpace() {
        return this.attributeNameSpace;
    }

    public AttributeStatus getAttributeStatus() {
        return this.attributeStatus;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributePinResponse(");
        sb.append("super=").append(super.toString());
        sb.append("attributeName=").append(String.valueOf(this.attributeName));
        sb.append(", notes=").append(String.valueOf(this.notes));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", attributeNameSpace=").append(String.valueOf((Object)this.attributeNameSpace));
        sb.append(", attributeStatus=").append(String.valueOf((Object)this.attributeStatus));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributePinResponse)) {
            return false;
        }
        AttributePinResponse other = (AttributePinResponse)((Object)o);
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.notes, other.notes) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.attributeNameSpace, (Object)other.attributeNameSpace) && Objects.equals((Object)this.attributeStatus, (Object)other.attributeStatus) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attributeName == null ? 43 : this.attributeName.hashCode());
        result = result * 59 + (this.notes == null ? 43 : this.notes.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.attributeNameSpace == null ? 43 : this.attributeNameSpace.hashCode());
        result = result * 59 + (this.attributeStatus == null ? 43 : this.attributeStatus.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AttributeStatus implements BmcEnum
    {
        AttributeAlreadyPinned("ATTRIBUTE_ALREADY_PINNED"),
        AttributePinned("ATTRIBUTE_PINNED"),
        PinNotAllowed("PIN_NOT_ALLOWED"),
        DuplicateAttribute("DUPLICATE_ATTRIBUTE"),
        InvalidAttribute("INVALID_ATTRIBUTE"),
        AttributeNotProcessed("ATTRIBUTE_NOT_PROCESSED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttributeStatus> map;

        private AttributeStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttributeStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttributeStatus.class);
            map = new HashMap<String, AttributeStatus>();
            for (AttributeStatus v : AttributeStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AttributeNameSpace implements BmcEnum
    {
        Traces("TRACES"),
        Synthetic("SYNTHETIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttributeNameSpace> map;

        private AttributeNameSpace(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeNameSpace create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttributeNameSpace', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttributeNameSpace.class);
            map = new HashMap<String, AttributeNameSpace>();
            for (AttributeNameSpace v : AttributeNameSpace.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationType implements BmcEnum
    {
        Pin("PIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attributeName")
        private String attributeName;
        @JsonProperty(value="notes")
        private String notes;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="attributeNameSpace")
        private AttributeNameSpace attributeNameSpace;
        @JsonProperty(value="attributeStatus")
        private AttributeStatus attributeStatus;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.__explicitlySet__.add("attributeName");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.__explicitlySet__.add("notes");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder attributeNameSpace(AttributeNameSpace attributeNameSpace) {
            this.attributeNameSpace = attributeNameSpace;
            this.__explicitlySet__.add("attributeNameSpace");
            return this;
        }

        public Builder attributeStatus(AttributeStatus attributeStatus) {
            this.attributeStatus = attributeStatus;
            this.__explicitlySet__.add("attributeStatus");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public AttributePinResponse build() {
            AttributePinResponse model = new AttributePinResponse(this.attributeName, this.notes, this.operationType, this.attributeNameSpace, this.attributeStatus, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttributePinResponse model) {
            if (model.wasPropertyExplicitlySet("attributeName")) {
                this.attributeName(model.getAttributeName());
            }
            if (model.wasPropertyExplicitlySet("notes")) {
                this.notes(model.getNotes());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("attributeNameSpace")) {
                this.attributeNameSpace(model.getAttributeNameSpace());
            }
            if (model.wasPropertyExplicitlySet("attributeStatus")) {
                this.attributeStatus(model.getAttributeStatus());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

