/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AttributeUpdateResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attributeName")
    private final String attributeName;
    @JsonProperty(value="attributeType")
    private final AttributeType attributeType;
    @JsonProperty(value="unit")
    private final Unit unit;
    @JsonProperty(value="notes")
    private final String notes;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="attributeStatus")
    private final AttributeStatus attributeStatus;
    @JsonProperty(value="attributeNameSpace")
    private final AttributeNameSpace attributeNameSpace;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"attributeName", "attributeType", "unit", "notes", "operationType", "attributeStatus", "attributeNameSpace", "timeUpdated"})
    public AttributeUpdateResponse(String attributeName, AttributeType attributeType, Unit unit, String notes, OperationType operationType, AttributeStatus attributeStatus, AttributeNameSpace attributeNameSpace, Date timeUpdated) {
        this.attributeName = attributeName;
        this.attributeType = attributeType;
        this.unit = unit;
        this.notes = notes;
        this.operationType = operationType;
        this.attributeStatus = attributeStatus;
        this.attributeNameSpace = attributeNameSpace;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String getNotes() {
        return this.notes;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public AttributeStatus getAttributeStatus() {
        return this.attributeStatus;
    }

    public AttributeNameSpace getAttributeNameSpace() {
        return this.attributeNameSpace;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeUpdateResponse(");
        sb.append("super=").append(super.toString());
        sb.append("attributeName=").append(String.valueOf(this.attributeName));
        sb.append(", attributeType=").append(String.valueOf((Object)this.attributeType));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(", notes=").append(String.valueOf(this.notes));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", attributeStatus=").append(String.valueOf((Object)this.attributeStatus));
        sb.append(", attributeNameSpace=").append(String.valueOf((Object)this.attributeNameSpace));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeUpdateResponse)) {
            return false;
        }
        AttributeUpdateResponse other = (AttributeUpdateResponse)((Object)o);
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals((Object)this.attributeType, (Object)other.attributeType) && Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals(this.notes, other.notes) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.attributeStatus, (Object)other.attributeStatus) && Objects.equals((Object)this.attributeNameSpace, (Object)other.attributeNameSpace) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attributeName == null ? 43 : this.attributeName.hashCode());
        result = result * 59 + (this.attributeType == null ? 43 : this.attributeType.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.notes == null ? 43 : this.notes.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.attributeStatus == null ? 43 : this.attributeStatus.hashCode());
        result = result * 59 + (this.attributeNameSpace == null ? 43 : this.attributeNameSpace.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AttributeNameSpace implements BmcEnum
    {
        Traces("TRACES"),
        Synthetic("SYNTHETIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttributeNameSpace> map;

        private AttributeNameSpace(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeNameSpace create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttributeNameSpace', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttributeNameSpace.class);
            map = new HashMap<String, AttributeNameSpace>();
            for (AttributeNameSpace v : AttributeNameSpace.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AttributeStatus implements BmcEnum
    {
        AttributeUpdated("ATTRIBUTE_UPDATED"),
        DuplicateAttribute("DUPLICATE_ATTRIBUTE"),
        InvalidAttribute("INVALID_ATTRIBUTE"),
        AttributeNotProcessed("ATTRIBUTE_NOT_PROCESSED"),
        AttributeDoesNotExist("ATTRIBUTE_DOES_NOT_EXIST"),
        AttributeUpdateNotAllowed("ATTRIBUTE_UPDATE_NOT_ALLOWED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttributeStatus> map;

        private AttributeStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttributeStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttributeStatus.class);
            map = new HashMap<String, AttributeStatus>();
            for (AttributeStatus v : AttributeStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationType implements BmcEnum
    {
        UpdateAttributeProperties("UPDATE_ATTRIBUTE_PROPERTIES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Unit implements BmcEnum
    {
        None("NONE"),
        EpochTimeMs("EPOCH_TIME_MS"),
        Bytes("BYTES"),
        Count("COUNT"),
        DurationMs("DURATION_MS"),
        TraceStatus("TRACE_STATUS"),
        Percentage("PERCENTAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Unit> map;

        private Unit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Unit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Unit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Unit.class);
            map = new HashMap<String, Unit>();
            for (Unit v : Unit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AttributeType implements BmcEnum
    {
        Numeric("NUMERIC"),
        String("STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttributeType> map;

        private AttributeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttributeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttributeType.class);
            map = new HashMap<String, AttributeType>();
            for (AttributeType v : AttributeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attributeName")
        private String attributeName;
        @JsonProperty(value="attributeType")
        private AttributeType attributeType;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonProperty(value="notes")
        private String notes;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="attributeStatus")
        private AttributeStatus attributeStatus;
        @JsonProperty(value="attributeNameSpace")
        private AttributeNameSpace attributeNameSpace;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.__explicitlySet__.add("attributeName");
            return this;
        }

        public Builder attributeType(AttributeType attributeType) {
            this.attributeType = attributeType;
            this.__explicitlySet__.add("attributeType");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.__explicitlySet__.add("notes");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder attributeStatus(AttributeStatus attributeStatus) {
            this.attributeStatus = attributeStatus;
            this.__explicitlySet__.add("attributeStatus");
            return this;
        }

        public Builder attributeNameSpace(AttributeNameSpace attributeNameSpace) {
            this.attributeNameSpace = attributeNameSpace;
            this.__explicitlySet__.add("attributeNameSpace");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public AttributeUpdateResponse build() {
            AttributeUpdateResponse model = new AttributeUpdateResponse(this.attributeName, this.attributeType, this.unit, this.notes, this.operationType, this.attributeStatus, this.attributeNameSpace, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttributeUpdateResponse model) {
            if (model.wasPropertyExplicitlySet("attributeName")) {
                this.attributeName(model.getAttributeName());
            }
            if (model.wasPropertyExplicitlySet("attributeType")) {
                this.attributeType(model.getAttributeType());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("notes")) {
                this.notes(model.getNotes());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("attributeStatus")) {
                this.attributeStatus(model.getAttributeStatus());
            }
            if (model.wasPropertyExplicitlySet("attributeNameSpace")) {
                this.attributeNameSpace(model.getAttributeNameSpace());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

