/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutoActivateToggleStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="state")
    private final String state;
    @JsonProperty(value="dataKey")
    private final DataKey dataKey;

    @Deprecated
    @ConstructorProperties(value={"status", "state", "dataKey"})
    public AutoActivateToggleStatus(Status status, String state, DataKey dataKey) {
        this.status = status;
        this.state = state;
        this.dataKey = dataKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getState() {
        return this.state;
    }

    public DataKey getDataKey() {
        return this.dataKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoActivateToggleStatus(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", dataKey=").append(String.valueOf((Object)this.dataKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoActivateToggleStatus)) {
            return false;
        }
        AutoActivateToggleStatus other = (AutoActivateToggleStatus)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.state, other.state) && Objects.equals((Object)this.dataKey, (Object)other.dataKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.dataKey == null ? 43 : this.dataKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DataKey implements BmcEnum
    {
        PrivateDataKey("PRIVATE_DATA_KEY"),
        PublicDataKey("PUBLIC_DATA_KEY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DataKey> map;

        private DataKey(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataKey create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DataKey', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DataKey.class);
            map = new HashMap<String, DataKey>();
            for (DataKey v : DataKey.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Success("SUCCESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="state")
        private String state;
        @JsonProperty(value="dataKey")
        private DataKey dataKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder dataKey(DataKey dataKey) {
            this.dataKey = dataKey;
            this.__explicitlySet__.add("dataKey");
            return this;
        }

        public AutoActivateToggleStatus build() {
            AutoActivateToggleStatus model = new AutoActivateToggleStatus(this.status, this.state, this.dataKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoActivateToggleStatus model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("dataKey")) {
                this.dataKey(model.getDataKey());
            }
            return this;
        }
    }
}

