/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkActivationMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationStatus")
    private final OperationStatus operationStatus;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="stringAttributesActivated")
    private final Integer stringAttributesActivated;
    @JsonProperty(value="numericAttributesActivated")
    private final Integer numericAttributesActivated;
    @JsonProperty(value="syntheticStringAttributesActivated")
    private final Integer syntheticStringAttributesActivated;
    @JsonProperty(value="syntheticNumericAttributesActivated")
    private final Integer syntheticNumericAttributesActivated;
    @JsonProperty(value="availableStringAttributes")
    private final Integer availableStringAttributes;
    @JsonProperty(value="availableNumericAttributes")
    private final Integer availableNumericAttributes;
    @JsonProperty(value="availableSyntheticStringAttributes")
    private final Integer availableSyntheticStringAttributes;
    @JsonProperty(value="availableSyntheticNumericAttributes")
    private final Integer availableSyntheticNumericAttributes;

    @Deprecated
    @ConstructorProperties(value={"operationStatus", "operationType", "stringAttributesActivated", "numericAttributesActivated", "syntheticStringAttributesActivated", "syntheticNumericAttributesActivated", "availableStringAttributes", "availableNumericAttributes", "availableSyntheticStringAttributes", "availableSyntheticNumericAttributes"})
    public BulkActivationMetadata(OperationStatus operationStatus, OperationType operationType, Integer stringAttributesActivated, Integer numericAttributesActivated, Integer syntheticStringAttributesActivated, Integer syntheticNumericAttributesActivated, Integer availableStringAttributes, Integer availableNumericAttributes, Integer availableSyntheticStringAttributes, Integer availableSyntheticNumericAttributes) {
        this.operationStatus = operationStatus;
        this.operationType = operationType;
        this.stringAttributesActivated = stringAttributesActivated;
        this.numericAttributesActivated = numericAttributesActivated;
        this.syntheticStringAttributesActivated = syntheticStringAttributesActivated;
        this.syntheticNumericAttributesActivated = syntheticNumericAttributesActivated;
        this.availableStringAttributes = availableStringAttributes;
        this.availableNumericAttributes = availableNumericAttributes;
        this.availableSyntheticStringAttributes = availableSyntheticStringAttributes;
        this.availableSyntheticNumericAttributes = availableSyntheticNumericAttributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Integer getStringAttributesActivated() {
        return this.stringAttributesActivated;
    }

    public Integer getNumericAttributesActivated() {
        return this.numericAttributesActivated;
    }

    public Integer getSyntheticStringAttributesActivated() {
        return this.syntheticStringAttributesActivated;
    }

    public Integer getSyntheticNumericAttributesActivated() {
        return this.syntheticNumericAttributesActivated;
    }

    public Integer getAvailableStringAttributes() {
        return this.availableStringAttributes;
    }

    public Integer getAvailableNumericAttributes() {
        return this.availableNumericAttributes;
    }

    public Integer getAvailableSyntheticStringAttributes() {
        return this.availableSyntheticStringAttributes;
    }

    public Integer getAvailableSyntheticNumericAttributes() {
        return this.availableSyntheticNumericAttributes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkActivationMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("operationStatus=").append(String.valueOf((Object)this.operationStatus));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", stringAttributesActivated=").append(String.valueOf(this.stringAttributesActivated));
        sb.append(", numericAttributesActivated=").append(String.valueOf(this.numericAttributesActivated));
        sb.append(", syntheticStringAttributesActivated=").append(String.valueOf(this.syntheticStringAttributesActivated));
        sb.append(", syntheticNumericAttributesActivated=").append(String.valueOf(this.syntheticNumericAttributesActivated));
        sb.append(", availableStringAttributes=").append(String.valueOf(this.availableStringAttributes));
        sb.append(", availableNumericAttributes=").append(String.valueOf(this.availableNumericAttributes));
        sb.append(", availableSyntheticStringAttributes=").append(String.valueOf(this.availableSyntheticStringAttributes));
        sb.append(", availableSyntheticNumericAttributes=").append(String.valueOf(this.availableSyntheticNumericAttributes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkActivationMetadata)) {
            return false;
        }
        BulkActivationMetadata other = (BulkActivationMetadata)((Object)o);
        return Objects.equals((Object)this.operationStatus, (Object)other.operationStatus) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.stringAttributesActivated, other.stringAttributesActivated) && Objects.equals(this.numericAttributesActivated, other.numericAttributesActivated) && Objects.equals(this.syntheticStringAttributesActivated, other.syntheticStringAttributesActivated) && Objects.equals(this.syntheticNumericAttributesActivated, other.syntheticNumericAttributesActivated) && Objects.equals(this.availableStringAttributes, other.availableStringAttributes) && Objects.equals(this.availableNumericAttributes, other.availableNumericAttributes) && Objects.equals(this.availableSyntheticStringAttributes, other.availableSyntheticStringAttributes) && Objects.equals(this.availableSyntheticNumericAttributes, other.availableSyntheticNumericAttributes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.stringAttributesActivated == null ? 43 : this.stringAttributesActivated.hashCode());
        result = result * 59 + (this.numericAttributesActivated == null ? 43 : this.numericAttributesActivated.hashCode());
        result = result * 59 + (this.syntheticStringAttributesActivated == null ? 43 : this.syntheticStringAttributesActivated.hashCode());
        result = result * 59 + (this.syntheticNumericAttributesActivated == null ? 43 : this.syntheticNumericAttributesActivated.hashCode());
        result = result * 59 + (this.availableStringAttributes == null ? 43 : this.availableStringAttributes.hashCode());
        result = result * 59 + (this.availableNumericAttributes == null ? 43 : this.availableNumericAttributes.hashCode());
        result = result * 59 + (this.availableSyntheticStringAttributes == null ? 43 : this.availableSyntheticStringAttributes.hashCode());
        result = result * 59 + (this.availableSyntheticNumericAttributes == null ? 43 : this.availableSyntheticNumericAttributes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationType implements BmcEnum
    {
        Activate("ACTIVATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationStatus implements BmcEnum
    {
        Success("SUCCESS"),
        EmptyAttributeList("EMPTY_ATTRIBUTE_LIST"),
        NumericAttributeLimitExceeded("NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED"),
        StringAttributeLimitExceeded("STRING_ATTRIBUTE_LIMIT_EXCEEDED"),
        InsufficientStringSpace("INSUFFICIENT_STRING_SPACE"),
        InsufficientNumericSpace("INSUFFICIENT_NUMERIC_SPACE"),
        InvalidBulkRequest("INVALID_BULK_REQUEST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationStatus> map;

        private OperationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationStatus.class);
            map = new HashMap<String, OperationStatus>();
            for (OperationStatus v : OperationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationStatus")
        private OperationStatus operationStatus;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="stringAttributesActivated")
        private Integer stringAttributesActivated;
        @JsonProperty(value="numericAttributesActivated")
        private Integer numericAttributesActivated;
        @JsonProperty(value="syntheticStringAttributesActivated")
        private Integer syntheticStringAttributesActivated;
        @JsonProperty(value="syntheticNumericAttributesActivated")
        private Integer syntheticNumericAttributesActivated;
        @JsonProperty(value="availableStringAttributes")
        private Integer availableStringAttributes;
        @JsonProperty(value="availableNumericAttributes")
        private Integer availableNumericAttributes;
        @JsonProperty(value="availableSyntheticStringAttributes")
        private Integer availableSyntheticStringAttributes;
        @JsonProperty(value="availableSyntheticNumericAttributes")
        private Integer availableSyntheticNumericAttributes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder stringAttributesActivated(Integer stringAttributesActivated) {
            this.stringAttributesActivated = stringAttributesActivated;
            this.__explicitlySet__.add("stringAttributesActivated");
            return this;
        }

        public Builder numericAttributesActivated(Integer numericAttributesActivated) {
            this.numericAttributesActivated = numericAttributesActivated;
            this.__explicitlySet__.add("numericAttributesActivated");
            return this;
        }

        public Builder syntheticStringAttributesActivated(Integer syntheticStringAttributesActivated) {
            this.syntheticStringAttributesActivated = syntheticStringAttributesActivated;
            this.__explicitlySet__.add("syntheticStringAttributesActivated");
            return this;
        }

        public Builder syntheticNumericAttributesActivated(Integer syntheticNumericAttributesActivated) {
            this.syntheticNumericAttributesActivated = syntheticNumericAttributesActivated;
            this.__explicitlySet__.add("syntheticNumericAttributesActivated");
            return this;
        }

        public Builder availableStringAttributes(Integer availableStringAttributes) {
            this.availableStringAttributes = availableStringAttributes;
            this.__explicitlySet__.add("availableStringAttributes");
            return this;
        }

        public Builder availableNumericAttributes(Integer availableNumericAttributes) {
            this.availableNumericAttributes = availableNumericAttributes;
            this.__explicitlySet__.add("availableNumericAttributes");
            return this;
        }

        public Builder availableSyntheticStringAttributes(Integer availableSyntheticStringAttributes) {
            this.availableSyntheticStringAttributes = availableSyntheticStringAttributes;
            this.__explicitlySet__.add("availableSyntheticStringAttributes");
            return this;
        }

        public Builder availableSyntheticNumericAttributes(Integer availableSyntheticNumericAttributes) {
            this.availableSyntheticNumericAttributes = availableSyntheticNumericAttributes;
            this.__explicitlySet__.add("availableSyntheticNumericAttributes");
            return this;
        }

        public BulkActivationMetadata build() {
            BulkActivationMetadata model = new BulkActivationMetadata(this.operationStatus, this.operationType, this.stringAttributesActivated, this.numericAttributesActivated, this.syntheticStringAttributesActivated, this.syntheticNumericAttributesActivated, this.availableStringAttributes, this.availableNumericAttributes, this.availableSyntheticStringAttributes, this.availableSyntheticNumericAttributes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkActivationMetadata model) {
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("stringAttributesActivated")) {
                this.stringAttributesActivated(model.getStringAttributesActivated());
            }
            if (model.wasPropertyExplicitlySet("numericAttributesActivated")) {
                this.numericAttributesActivated(model.getNumericAttributesActivated());
            }
            if (model.wasPropertyExplicitlySet("syntheticStringAttributesActivated")) {
                this.syntheticStringAttributesActivated(model.getSyntheticStringAttributesActivated());
            }
            if (model.wasPropertyExplicitlySet("syntheticNumericAttributesActivated")) {
                this.syntheticNumericAttributesActivated(model.getSyntheticNumericAttributesActivated());
            }
            if (model.wasPropertyExplicitlySet("availableStringAttributes")) {
                this.availableStringAttributes(model.getAvailableStringAttributes());
            }
            if (model.wasPropertyExplicitlySet("availableNumericAttributes")) {
                this.availableNumericAttributes(model.getAvailableNumericAttributes());
            }
            if (model.wasPropertyExplicitlySet("availableSyntheticStringAttributes")) {
                this.availableSyntheticStringAttributes(model.getAvailableSyntheticStringAttributes());
            }
            if (model.wasPropertyExplicitlySet("availableSyntheticNumericAttributes")) {
                this.availableSyntheticNumericAttributes(model.getAvailableSyntheticNumericAttributes());
            }
            return this;
        }
    }
}

