/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkPinMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationStatus")
    private final OperationStatus operationStatus;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="attributesPinned")
    private final Integer attributesPinned;
    @JsonProperty(value="syntheticAttributesPinned")
    private final Integer syntheticAttributesPinned;

    @Deprecated
    @ConstructorProperties(value={"operationStatus", "operationType", "attributesPinned", "syntheticAttributesPinned"})
    public BulkPinMetadata(OperationStatus operationStatus, OperationType operationType, Integer attributesPinned, Integer syntheticAttributesPinned) {
        this.operationStatus = operationStatus;
        this.operationType = operationType;
        this.attributesPinned = attributesPinned;
        this.syntheticAttributesPinned = syntheticAttributesPinned;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Integer getAttributesPinned() {
        return this.attributesPinned;
    }

    public Integer getSyntheticAttributesPinned() {
        return this.syntheticAttributesPinned;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkPinMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("operationStatus=").append(String.valueOf((Object)this.operationStatus));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", attributesPinned=").append(String.valueOf(this.attributesPinned));
        sb.append(", syntheticAttributesPinned=").append(String.valueOf(this.syntheticAttributesPinned));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkPinMetadata)) {
            return false;
        }
        BulkPinMetadata other = (BulkPinMetadata)((Object)o);
        return Objects.equals((Object)this.operationStatus, (Object)other.operationStatus) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.attributesPinned, other.attributesPinned) && Objects.equals(this.syntheticAttributesPinned, other.syntheticAttributesPinned) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.attributesPinned == null ? 43 : this.attributesPinned.hashCode());
        result = result * 59 + (this.syntheticAttributesPinned == null ? 43 : this.syntheticAttributesPinned.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationType implements BmcEnum
    {
        Pin("PIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationStatus implements BmcEnum
    {
        Success("SUCCESS"),
        EmptyAttributeList("EMPTY_ATTRIBUTE_LIST"),
        InvalidBulkRequest("INVALID_BULK_REQUEST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationStatus> map;

        private OperationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationStatus.class);
            map = new HashMap<String, OperationStatus>();
            for (OperationStatus v : OperationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationStatus")
        private OperationStatus operationStatus;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="attributesPinned")
        private Integer attributesPinned;
        @JsonProperty(value="syntheticAttributesPinned")
        private Integer syntheticAttributesPinned;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder attributesPinned(Integer attributesPinned) {
            this.attributesPinned = attributesPinned;
            this.__explicitlySet__.add("attributesPinned");
            return this;
        }

        public Builder syntheticAttributesPinned(Integer syntheticAttributesPinned) {
            this.syntheticAttributesPinned = syntheticAttributesPinned;
            this.__explicitlySet__.add("syntheticAttributesPinned");
            return this;
        }

        public BulkPinMetadata build() {
            BulkPinMetadata model = new BulkPinMetadata(this.operationStatus, this.operationType, this.attributesPinned, this.syntheticAttributesPinned);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkPinMetadata model) {
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("attributesPinned")) {
                this.attributesPinned(model.getAttributesPinned());
            }
            if (model.wasPropertyExplicitlySet("syntheticAttributesPinned")) {
                this.syntheticAttributesPinned(model.getSyntheticAttributesPinned());
            }
            return this;
        }
    }
}

