/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apmtraces.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkUpdateAttributeDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attributeName")
    private final String attributeName;
    @JsonProperty(value="unit")
    private final Unit unit;
    @JsonProperty(value="attributeNameSpace")
    private final AttributeNameSpace attributeNameSpace;

    @Deprecated
    @ConstructorProperties(value={"attributeName", "unit", "attributeNameSpace"})
    public BulkUpdateAttributeDetail(String attributeName, Unit unit, AttributeNameSpace attributeNameSpace) {
        this.attributeName = attributeName;
        this.unit = unit;
        this.attributeNameSpace = attributeNameSpace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public AttributeNameSpace getAttributeNameSpace() {
        return this.attributeNameSpace;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkUpdateAttributeDetail(");
        sb.append("super=").append(super.toString());
        sb.append("attributeName=").append(String.valueOf(this.attributeName));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(", attributeNameSpace=").append(String.valueOf((Object)this.attributeNameSpace));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkUpdateAttributeDetail)) {
            return false;
        }
        BulkUpdateAttributeDetail other = (BulkUpdateAttributeDetail)((Object)o);
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals((Object)this.attributeNameSpace, (Object)other.attributeNameSpace) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attributeName == null ? 43 : this.attributeName.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.attributeNameSpace == null ? 43 : this.attributeNameSpace.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AttributeNameSpace implements BmcEnum
    {
        Traces("TRACES"),
        Synthetic("SYNTHETIC");

        private final String value;
        private static Map<String, AttributeNameSpace> map;

        private AttributeNameSpace(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttributeNameSpace create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AttributeNameSpace: " + key);
        }

        static {
            map = new HashMap<String, AttributeNameSpace>();
            for (AttributeNameSpace v : AttributeNameSpace.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Unit implements BmcEnum
    {
        None("NONE"),
        EpochTimeMs("EPOCH_TIME_MS"),
        Bytes("BYTES"),
        Count("COUNT"),
        DurationMs("DURATION_MS"),
        TraceStatus("TRACE_STATUS"),
        Percentage("PERCENTAGE");

        private final String value;
        private static Map<String, Unit> map;

        private Unit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Unit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Unit: " + key);
        }

        static {
            map = new HashMap<String, Unit>();
            for (Unit v : Unit.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attributeName")
        private String attributeName;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonProperty(value="attributeNameSpace")
        private AttributeNameSpace attributeNameSpace;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.__explicitlySet__.add("attributeName");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder attributeNameSpace(AttributeNameSpace attributeNameSpace) {
            this.attributeNameSpace = attributeNameSpace;
            this.__explicitlySet__.add("attributeNameSpace");
            return this;
        }

        public BulkUpdateAttributeDetail build() {
            BulkUpdateAttributeDetail model = new BulkUpdateAttributeDetail(this.attributeName, this.unit, this.attributeNameSpace);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkUpdateAttributeDetail model) {
            if (model.wasPropertyExplicitlySet("attributeName")) {
                this.attributeName(model.getAttributeName());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("attributeNameSpace")) {
                this.attributeNameSpace(model.getAttributeNameSpace());
            }
            return this;
        }
    }
}

